/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.domain;

import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.net.BytesCompressor;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/sessionreplay/internal/domain/RequestBodyFactory;", "", "compressor", "Lcom/datadog/android/sessionreplay/net/BytesCompressor;", "(Lcom/datadog/android/sessionreplay/net/BytesCompressor;)V", "buildRequestBody", "Lokhttp3/RequestBody;", "segment", "Lcom/datadog/android/sessionreplay/model/MobileSegment;", "segmentAsBinary", "", "create", "serializedSegment", "Lcom/google/gson/JsonObject;", "Companion", "dd-sdk-android_release"})
public final class RequestBodyFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesCompressor compressor;
    @NotNull
    public static final String APPLICATION_ID_FORM_KEY = "application.id";
    @NotNull
    public static final String SESSION_ID_FORM_KEY = "session.id";
    @NotNull
    public static final String VIEW_ID_FORM_KEY = "view.id";
    @NotNull
    public static final String HAS_FULL_SNAPSHOT_FORM_KEY = "has_full_snapshot";
    @NotNull
    public static final String RECORDS_COUNT_FORM_KEY = "records_count";
    @NotNull
    public static final String RAW_SEGMENT_SIZE_FORM_KEY = "raw_segment_size";
    @NotNull
    public static final String START_TIMESTAMP_FORM_KEY = "start";
    @NotNull
    public static final String END_TIMESTAMP_FORM_KEY = "end";
    @NotNull
    public static final String SOURCE_FORM_KEY = "source";
    @NotNull
    public static final String SEGMENT_FORM_KEY = "segment";
    @NotNull
    public static final String CONTENT_TYPE_BINARY = "application/octet-stream";

    public RequestBodyFactory(@NotNull BytesCompressor compressor) {
        Intrinsics.checkNotNullParameter((Object)compressor, (String)"compressor");
        this.compressor = compressor;
    }

    public /* synthetic */ RequestBodyFactory(BytesCompressor bytesCompressor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bytesCompressor = new BytesCompressor();
        }
        this(bytesCompressor);
    }

    @NotNull
    public final RequestBody create(@NotNull MobileSegment segment, @NotNull JsonObject serializedSegment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)SEGMENT_FORM_KEY);
        Intrinsics.checkNotNullParameter((Object)serializedSegment, (String)"serializedSegment");
        String string = serializedSegment.toString() + "\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] segmentAsBinary = byArray;
        return this.buildRequestBody(segment, segmentAsBinary);
    }

    private final RequestBody buildRequestBody(MobileSegment segment, byte[] segmentAsBinary) {
        byte[] compressedData = this.compressor.compressBytes(segmentAsBinary);
        MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(SEGMENT_FORM_KEY, segment.getSession().getId(), RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_BINARY), (byte[])compressedData)).addFormDataPart(APPLICATION_ID_FORM_KEY, segment.getApplication().getId()).addFormDataPart(SESSION_ID_FORM_KEY, segment.getSession().getId()).addFormDataPart(VIEW_ID_FORM_KEY, segment.getView().getId()).addFormDataPart(HAS_FULL_SNAPSHOT_FORM_KEY, String.valueOf(segment.getHasFullSnapshot())).addFormDataPart(RECORDS_COUNT_FORM_KEY, String.valueOf(segment.getRecordsCount())).addFormDataPart(RAW_SEGMENT_SIZE_FORM_KEY, String.valueOf(compressedData.length)).addFormDataPart(START_TIMESTAMP_FORM_KEY, String.valueOf(segment.getStart())).addFormDataPart(END_TIMESTAMP_FORM_KEY, String.valueOf(segment.getEnd())).addFormDataPart(SOURCE_FORM_KEY, segment.getSource().toJson().getAsString()).build();
        Intrinsics.checkNotNullExpressionValue((Object)multipartBody, (String)"Builder()\n            .s\u2026   )\n            .build()");
        return (RequestBody)multipartBody;
    }

    public RequestBodyFactory() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/sessionreplay/internal/domain/RequestBodyFactory$Companion;", "", "()V", "APPLICATION_ID_FORM_KEY", "", "CONTENT_TYPE_BINARY", "END_TIMESTAMP_FORM_KEY", "HAS_FULL_SNAPSHOT_FORM_KEY", "RAW_SEGMENT_SIZE_FORM_KEY", "RECORDS_COUNT_FORM_KEY", "SEGMENT_FORM_KEY", "SESSION_ID_FORM_KEY", "SOURCE_FORM_KEY", "START_TIMESTAMP_FORM_KEY", "VIEW_ID_FORM_KEY", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

