/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.domain;

import com.datadog.android.sessionreplay.internal.domain.RequestBodyFactory;
import com.datadog.android.sessionreplay.internal.exception.InvalidPayloadFormatException;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.net.BatchesToSegmentsMapper;
import com.datadog.android.v2.api.Request;
import com.datadog.android.v2.api.RequestFactory;
import com.datadog.android.v2.api.context.DatadogContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/datadog/android/sessionreplay/internal/domain/SessionReplayRequestFactory;", "Lcom/datadog/android/v2/api/RequestFactory;", "endpoint", "", "batchToSegmentsMapper", "Lcom/datadog/android/sessionreplay/net/BatchesToSegmentsMapper;", "requestBodyFactory", "Lcom/datadog/android/sessionreplay/internal/domain/RequestBodyFactory;", "(Ljava/lang/String;Lcom/datadog/android/sessionreplay/net/BatchesToSegmentsMapper;Lcom/datadog/android/sessionreplay/internal/domain/RequestBodyFactory;)V", "intakeUrl", "getIntakeUrl", "()Ljava/lang/String;", "intakeUrl$delegate", "Lkotlin/Lazy;", "buildQueryParameters", "", "", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "buildUrl", "create", "Lcom/datadog/android/v2/api/Request;", "context", "batchData", "", "", "batchMetadata", "extractByteArrayFromBody", "body", "Lokhttp3/RequestBody;", "resolveHeaders", "requestId", "resolveRequest", "tags", "Companion", "dd-sdk-android_release"})
public final class SessionReplayRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String endpoint;
    @NotNull
    private final BatchesToSegmentsMapper batchToSegmentsMapper;
    @NotNull
    private final RequestBodyFactory requestBodyFactory;
    @NotNull
    private final Lazy intakeUrl$delegate;
    @NotNull
    private static final String UPLOAD_URL = "%s/api/v2/%s";

    public SessionReplayRequestFactory(@NotNull String endpoint, @NotNull BatchesToSegmentsMapper batchToSegmentsMapper, @NotNull RequestBodyFactory requestBodyFactory) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)batchToSegmentsMapper, (String)"batchToSegmentsMapper");
        Intrinsics.checkNotNullParameter((Object)requestBodyFactory, (String)"requestBodyFactory");
        this.endpoint = endpoint;
        this.batchToSegmentsMapper = batchToSegmentsMapper;
        this.requestBodyFactory = requestBodyFactory;
        this.intakeUrl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ SessionReplayRequestFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Locale locale = Locale.US;
                String string = "%s/api/v2/%s";
                Object[] objectArray = new Object[]{SessionReplayRequestFactory.access$getEndpoint$p(this.this$0), "replay"};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                return string2;
            }
        }));
    }

    public /* synthetic */ SessionReplayRequestFactory(String string, BatchesToSegmentsMapper batchesToSegmentsMapper, RequestBodyFactory requestBodyFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            batchesToSegmentsMapper = new BatchesToSegmentsMapper();
        }
        if ((n & 4) != 0) {
            requestBodyFactory = new RequestBodyFactory(null, 1, null);
        }
        this(string, batchesToSegmentsMapper, requestBodyFactory);
    }

    private final String getIntakeUrl() {
        Lazy lazy = this.intakeUrl$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Request create(@NotNull DatadogContext context, @NotNull List<byte[]> batchData, @Nullable byte[] batchMetadata) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        Pair serializedSegmentPair = this.batchToSegmentsMapper.map(batchData);
        if (serializedSegmentPair == null) {
            throw new InvalidPayloadFormatException("The payload format was broken and an upload request could not be created");
        }
        RequestBody body = this.requestBodyFactory.create((MobileSegment)serializedSegmentPair.getFirst(), (JsonObject)serializedSegmentPair.getSecond());
        return this.resolveRequest(context, body);
    }

    private final String tags(DatadogContext datadogContext) {
        Object[] objectArray = new String[]{"service:" + datadogContext.getService(), "version:" + datadogContext.getVersion(), "sdk_version:" + datadogContext.getSdkVersion(), "env:" + datadogContext.getEnv()};
        List elements = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)datadogContext.getVariant()).length() > 0) {
            elements.add("variant:" + datadogContext.getVariant());
        }
        return CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildUrl(DatadogContext datadogContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<String, Object> queryParams;
        Map<String, Object> map = queryParams = this.buildQueryParameters(datadogContext);
        String string = this.getIntakeUrl();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        return string + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
    }

    private final Map<String, String> resolveHeaders(DatadogContext datadogContext, String requestId) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)datadogContext.getClientToken()), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)datadogContext.getSource()), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)datadogContext.getSdkVersion()), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> buildQueryParameters(DatadogContext datadogContext) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ddsource", (Object)datadogContext.getSource()), TuplesKt.to((Object)"ddtags", (Object)this.tags(datadogContext))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Request resolveRequest(DatadogContext context, RequestBody body) {
        byte[] bodyAsByteArray = this.extractByteArrayFromBody(body);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        String description = "Session Replay Segment Upload Request";
        Map<String, String> headers = this.resolveHeaders(context, requestId);
        String requestUrl = this.buildUrl(context);
        return new Request(requestId, description, requestUrl, headers, bodyAsByteArray, String.valueOf(body.contentType()));
    }

    private final byte[] extractByteArrayFromBody(RequestBody body) {
        Buffer buffer = new Buffer();
        body.writeTo((BufferedSink)buffer);
        byte[] byArray = buffer.readByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.readByteArray()");
        return byArray;
    }

    public static final /* synthetic */ String access$getEndpoint$p(SessionReplayRequestFactory $this) {
        return $this.endpoint;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/domain/SessionReplayRequestFactory$Companion;", "", "()V", "UPLOAD_URL", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

