/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.telemetry.internal;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import com.datadog.android.v2.api.InternalLogger;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT", "", "tryFromSource", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent$Source;", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent$Source$Companion;", "source", "Lcom/datadog/android/telemetry/model/TelemetryDebugEvent$Source;", "Lcom/datadog/android/telemetry/model/TelemetryDebugEvent$Source$Companion;", "Lcom/datadog/android/telemetry/model/TelemetryErrorEvent$Source;", "Lcom/datadog/android/telemetry/model/TelemetryErrorEvent$Source$Companion;", "dd-sdk-android_release"})
public final class TelemetryEventExtKt {
    @NotNull
    public static final String UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT = "You are using an unknown source %s for your events";

    @Nullable
    public static final TelemetryDebugEvent.Source tryFromSource(@NotNull TelemetryDebugEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        TelemetryDebugEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }

    @Nullable
    public static final TelemetryErrorEvent.Source tryFromSource(@NotNull TelemetryErrorEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        TelemetryErrorEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }

    @Nullable
    public static final TelemetryConfigurationEvent.Source tryFromSource(@NotNull TelemetryConfigurationEvent.Source.Companion $this$tryFromSource, @NotNull String source) {
        TelemetryConfigurationEvent.Source source2;
        Intrinsics.checkNotNullParameter((Object)$this$tryFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source2 = $this$tryFromSource.fromJson(source);
        }
        catch (NoSuchElementException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            String string = UNKNOWN_SOURCE_WARNING_MESSAGE_FORMAT;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{source};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, (Throwable)e);
            source2 = null;
        }
        return source2;
    }
}

