/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing;

import androidx.annotation.FloatRange;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.tracing.TracingHeaderType;
import com.datadog.android.tracing.internal.TracingFeature;
import com.datadog.android.tracing.internal.data.NoOpWriter;
import com.datadog.android.tracing.internal.handlers.AndroidSpanLogsHandler;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.DatadogCore;
import com.datadog.android.v2.core.NoOpSdkCore;
import com.datadog.opentracing.DDTracer;
import com.datadog.opentracing.LogHandler;
import com.datadog.trace.api.Config;
import com.datadog.trace.common.writer.Writer;
import com.datadog.trace.context.ScopeListener;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00060\u0010R\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00060\u0010R\u00020\u0001*\u00060\u0010R\u00020\u0001H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/tracing/AndroidTracer;", "Lcom/datadog/opentracing/DDTracer;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "config", "Lcom/datadog/trace/api/Config;", "writer", "Lcom/datadog/trace/common/writer/Writer;", "random", "Ljava/util/Random;", "logsHandler", "Lcom/datadog/opentracing/LogHandler;", "bundleWithRum", "", "(Lcom/datadog/android/v2/api/SdkCore;Lcom/datadog/trace/api/Config;Lcom/datadog/trace/common/writer/Writer;Ljava/util/Random;Lcom/datadog/opentracing/LogHandler;Z)V", "buildSpan", "Lcom/datadog/opentracing/DDTracer$DDSpanBuilder;", "operationName", "", "withRumContext", "Builder", "Companion", "dd-sdk-android_release"})
public final class AndroidTracer
extends DDTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private final LogHandler logsHandler;
    private final boolean bundleWithRum;
    public static final double DEFAULT_SAMPLING_RATE = 100.0;
    @NotNull
    public static final String TRACING_NOT_ENABLED_ERROR_MESSAGE = "You're trying to create an AndroidTracer instance, but either the SDK was not initialized or the Tracing feature was disabled in your Configuration. No tracing data will be sent.";
    @NotNull
    public static final String RUM_NOT_ENABLED_ERROR_MESSAGE = "You're trying to bundle the traces with a RUM context, but the RUM feature was disabled in your Configuration. No RUM context will be attached to your traces in this case.";
    public static final int DEFAULT_PARTIAL_MIN_FLUSH = 5;
    public static final int TRACE_ID_BIT_SIZE = 63;

    public AndroidTracer(@NotNull SdkCore sdkCore, @NotNull Config config, @NotNull Writer writer, @NotNull Random random2, @NotNull LogHandler logsHandler, boolean bundleWithRum) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
        Intrinsics.checkNotNullParameter((Object)logsHandler, (String)"logsHandler");
        super(config, writer, random2);
        this.sdkCore = sdkCore;
        this.logsHandler = logsHandler;
        this.bundleWithRum = bundleWithRum;
        this.addScopeListener(new ScopeListener(){

            @Override
            public void afterScopeActivated() {
                SpanContext activeContext;
                String threadName = Thread.currentThread().getName();
                Span span = this.activeSpan();
                Object object = activeContext = span == null ? null : span.context();
                if (activeContext != null) {
                    String activeSpanId = activeContext.toSpanId();
                    String activeTraceId = activeContext.toTraceId();
                    sdkCore.updateFeatureContext("tracing", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(threadName, activeSpanId, activeTraceId){
                        final /* synthetic */ String $threadName;
                        final /* synthetic */ String $activeSpanId;
                        final /* synthetic */ String $activeTraceId;
                        {
                            this.$threadName = $threadName;
                            this.$activeSpanId = $activeSpanId;
                            this.$activeTraceId = $activeTraceId;
                            super(1);
                        }

                        public final void invoke(@NotNull Map<String, Object> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"span_id", (Object)this.$activeSpanId), TuplesKt.to((Object)"trace_id", (Object)this.$activeTraceId)};
                            it.put("context@" + this.$threadName, MapsKt.mapOf((Pair[])pairArray));
                        }
                    }));
                }
            }

            @Override
            public void afterScopeClosed() {
                String threadName = Thread.currentThread().getName();
                sdkCore.updateFeatureContext("tracing", (Function1<? super Map<String, Object>, Unit>)((Function1)new Function1<Map<String, Object>, Unit>(threadName){
                    final /* synthetic */ String $threadName;
                    {
                        this.$threadName = $threadName;
                        super(1);
                    }

                    public final void invoke(@NotNull Map<String, Object> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        it.remove("context@" + this.$threadName);
                    }
                }));
            }
        });
    }

    @Override
    @NotNull
    public DDTracer.DDSpanBuilder buildSpan(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        DDTracer.DDSpanBuilder dDSpanBuilder = new DDTracer.DDSpanBuilder(this, operationName, this.scopeManager()).withLogHandler(this.logsHandler);
        Intrinsics.checkNotNullExpressionValue((Object)dDSpanBuilder, (String)"DDSpanBuilder(operationN\u2026thLogHandler(logsHandler)");
        return this.withRumContext(dDSpanBuilder);
    }

    private final DDTracer.DDSpanBuilder withRumContext(DDTracer.DDSpanBuilder $this$withRumContext) {
        DDTracer.DDSpanBuilder dDSpanBuilder;
        if (this.bundleWithRum) {
            Map<String, Object> rumContext = this.sdkCore.getFeatureContext("rum");
            Object object = rumContext.get("application_id");
            DDTracer.DDSpanBuilder dDSpanBuilder2 = $this$withRumContext.withTag("application_id", object instanceof String ? (String)object : null);
            object = rumContext.get("session_id");
            DDTracer.DDSpanBuilder dDSpanBuilder3 = dDSpanBuilder2.withTag("session_id", object instanceof String ? (String)object : null);
            object = rumContext.get("view_id");
            DDTracer.DDSpanBuilder dDSpanBuilder4 = dDSpanBuilder3.withTag("view.id", object instanceof String ? (String)object : null);
            object = rumContext.get("action_id");
            DDTracer.DDSpanBuilder dDSpanBuilder5 = dDSpanBuilder4.withTag("user_action.id", object instanceof String ? (String)object : null);
            Intrinsics.checkNotNullExpressionValue((Object)dDSpanBuilder5, (String)"{\n            val rumCon\u2026d\"] as? String)\n        }");
            dDSpanBuilder = dDSpanBuilder5;
        } else {
            dDSpanBuilder = $this$withRumContext;
        }
        return dDSpanBuilder;
    }

    @JvmStatic
    public static final void logThrowable(@NotNull Span span, @NotNull Throwable throwable) {
        Companion.logThrowable(span, throwable);
    }

    @JvmStatic
    public static final void logErrorMessage(@NotNull Span span, @NotNull String message) {
        Companion.logErrorMessage(span, message);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\fJ\u0010\u0010#\u001a\u00020\u00002\b\b\u0001\u0010\u000f\u001a\u00020\u0010J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\nJ\u0014\u0010%\u001a\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0015\u0010'\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/datadog/android/tracing/AndroidTracer$Builder;", "", "()V", "logsHandler", "Lcom/datadog/opentracing/LogHandler;", "(Lcom/datadog/opentracing/LogHandler;)V", "bundleWithRumEnabled", "", "globalTags", "", "", "partialFlushThreshold", "", "random", "Ljava/util/Random;", "samplingRate", "", "serviceName", "tracingHeaderTypes", "", "Lcom/datadog/android/tracing/TracingHeaderType;", "addGlobalTag", "key", "value", "build", "Lcom/datadog/android/tracing/AndroidTracer;", "config", "Lcom/datadog/trace/api/Config;", "properties", "Ljava/util/Properties;", "properties$dd_sdk_android_release", "setBundleWithRumEnabled", "enabled", "setPartialFlushThreshold", "threshold", "setSamplingRate", "setServiceName", "setTracingHeaderTypes", "headerTypes", "withRandom", "withRandom$dd_sdk_android_release", "dd-sdk-android_release"})
    public static final class Builder {
        @NotNull
        private final LogHandler logsHandler;
        @NotNull
        private Set<? extends TracingHeaderType> tracingHeaderTypes;
        private boolean bundleWithRumEnabled;
        private double samplingRate;
        @Nullable
        private String serviceName;
        private int partialFlushThreshold;
        @NotNull
        private Random random;
        @NotNull
        private final Map<String, String> globalTags;

        public Builder(@NotNull LogHandler logsHandler) {
            DatadogCore datadogCore;
            Intrinsics.checkNotNullParameter((Object)logsHandler, (String)"logsHandler");
            this.logsHandler = logsHandler;
            this.tracingHeaderTypes = SetsKt.setOf((Object)((Object)TracingHeaderType.DATADOG));
            this.bundleWithRumEnabled = true;
            this.samplingRate = 100.0;
            Object object = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
            DatadogCore datadogCore2 = datadogCore = object instanceof DatadogCore ? (DatadogCore)object : null;
            this.serviceName = datadogCore == null ? null : ((object = datadogCore.getCoreFeature$dd_sdk_android_release()) == null ? null : ((CoreFeature)object).getServiceName$dd_sdk_android_release());
            this.partialFlushThreshold = 5;
            this.random = new SecureRandom();
            this.globalTags = new LinkedHashMap();
        }

        public Builder() {
            this(new AndroidSpanLogsHandler(Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release()));
        }

        @NotNull
        public final AndroidTracer build() {
            RumFeature rumFeature;
            DatadogCore datadogCore;
            SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
            DatadogCore datadogCore2 = datadogCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
            TracingFeature tracingFeature = datadogCore2 == null ? null : datadogCore2.getTracingFeature$dd_sdk_android_release();
            DatadogCore datadogCore3 = datadogCore;
            RumFeature rumFeature2 = rumFeature = datadogCore3 == null ? null : datadogCore3.getRumFeature$dd_sdk_android_release();
            if (tracingFeature == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, "You're trying to create an AndroidTracer instance, but either the SDK was not initialized or the Tracing feature was disabled in your Configuration. No tracing data will be sent.\nPlease add the following code in your application's onCreate() method:\nval credentials = Credentials(\"<CLIENT_TOKEN>\", \"<ENVIRONMENT>\", \"<VARIANT>\", \"<APPLICATION_ID>\")\nDatadog.initialize(context, credentials, configuration, trackingConsent);", null, 8, null);
            }
            if (this.bundleWithRumEnabled && rumFeature == null) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.USER, AndroidTracer.RUM_NOT_ENABLED_ERROR_MESSAGE, null, 8, null);
                this.bundleWithRumEnabled = false;
            }
            DatadogCore datadogCore4 = datadogCore;
            SdkCore sdkCore2 = datadogCore4 == null ? (SdkCore)new NoOpSdkCore() : (SdkCore)datadogCore4;
            Config config = this.config();
            TracingFeature tracingFeature2 = tracingFeature;
            Writer writer = tracingFeature2 == null ? null : tracingFeature2.getDataWriter$dd_sdk_android_release();
            if (writer == null) {
                writer = new NoOpWriter();
            }
            return new AndroidTracer(sdkCore2, config, writer, this.random, this.logsHandler, this.bundleWithRumEnabled);
        }

        @NotNull
        public final Builder setTracingHeaderTypes(@NotNull Set<? extends TracingHeaderType> headerTypes) {
            Intrinsics.checkNotNullParameter(headerTypes, (String)"headerTypes");
            this.tracingHeaderTypes = headerTypes;
            return this;
        }

        @NotNull
        public final Builder setServiceName(@NotNull String serviceName) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            this.serviceName = serviceName;
            return this;
        }

        @NotNull
        public final Builder setPartialFlushThreshold(int threshold) {
            this.partialFlushThreshold = threshold;
            return this;
        }

        @NotNull
        public final Builder addGlobalTag(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.globalTags.put(key, value);
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setSamplingRate(@FloatRange(from=0.0, to=100.0) double samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        @NotNull
        public final Builder withRandom$dd_sdk_android_release(@NotNull Random random2) {
            Intrinsics.checkNotNullParameter((Object)random2, (String)"random");
            this.random = random2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Properties properties$dd_sdk_android_release() {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Properties properties = new Properties();
            if (this.serviceName != null) {
                properties.setProperty("service.name", this.serviceName);
            }
            properties.setProperty("trace.partial.flush.min.spans", String.valueOf(this.partialFlushThreshold));
            Map<String, String> map = this.globalTags;
            String string = "tags";
            Properties properties2 = properties;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((CallSite)((Object)(it.getKey() + ":" + it.getValue())));
            }
            collection = (List)destination$iv$iv;
            properties2.setProperty(string, CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            properties.setProperty("trace.sample.rate", String.valueOf(this.samplingRate / 100.0));
            String propagationStyles = CollectionsKt.joinToString$default((Iterable)this.tracingHeaderTypes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            properties.setProperty("propagation.style.extract", propagationStyles);
            properties.setProperty("propagation.style.inject", propagationStyles);
            return properties;
        }

        private final Config config() {
            Config config = Config.get(this.properties$dd_sdk_android_release());
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"get(properties())");
            return config;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/tracing/AndroidTracer$Companion;", "", "()V", "DEFAULT_PARTIAL_MIN_FLUSH", "", "DEFAULT_SAMPLING_RATE", "", "RUM_NOT_ENABLED_ERROR_MESSAGE", "", "TRACE_ID_BIT_SIZE", "TRACING_NOT_ENABLED_ERROR_MESSAGE", "logErrorMessage", "", "span", "Lio/opentracing/Span;", "message", "logThrowable", "throwable", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void logThrowable(@NotNull Span span, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Map fieldsMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.object", (Object)throwable));
            span.log(fieldsMap);
        }

        @JvmStatic
        public final void logErrorMessage(@NotNull Span span, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Map fieldsMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
            span.log(fieldsMap);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

