/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal;

import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.tracing.internal.data.NoOpWriter;
import com.datadog.android.tracing.internal.data.TraceWriter;
import com.datadog.android.tracing.internal.domain.event.DdSpanToSpanEventMapper;
import com.datadog.android.tracing.internal.domain.event.SpanEventMapperWrapper;
import com.datadog.android.tracing.internal.domain.event.SpanEventSerializer;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.trace.common.writer.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/tracing/internal/TracingFeature;", "", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "(Lcom/datadog/android/v2/api/SdkCore;)V", "dataWriter", "Lcom/datadog/trace/common/writer/Writer;", "getDataWriter$dd_sdk_android_release", "()Lcom/datadog/trace/common/writer/Writer;", "setDataWriter$dd_sdk_android_release", "(Lcom/datadog/trace/common/writer/Writer;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "createDataWriter", "configuration", "Lcom/datadog/android/core/configuration/Configuration$Feature$Tracing;", "initialize", "", "stop", "Companion", "dd-sdk-android_release"})
public final class TracingFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    private Writer dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    public static final String TRACING_FEATURE_NAME = "tracing";

    public TracingFeature(@NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
        this.dataWriter = new NoOpWriter();
        this.initialized = new AtomicBoolean(false);
    }

    @NotNull
    public final Writer getDataWriter$dd_sdk_android_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_release(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"<set-?>");
        this.dataWriter = writer;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_release() {
        return this.initialized;
    }

    public final void initialize(@NotNull Configuration.Feature.Tracing configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.dataWriter = this.createDataWriter(configuration);
        this.initialized.set(true);
    }

    public final void stop() {
        this.dataWriter = new NoOpWriter();
        this.initialized.set(false);
    }

    private final Writer createDataWriter(Configuration.Feature.Tracing configuration) {
        return new TraceWriter(this.sdkCore, new DdSpanToSpanEventMapper(), new SpanEventMapperWrapper(configuration.getSpanEventMapper()), new SpanEventSerializer(null, 1, null), RuntimeUtilsKt.getInternalLogger());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/tracing/internal/TracingFeature$Companion;", "", "()V", "TRACING_FEATURE_NAME", "", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

