/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.domain.event;

import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.tracing.model.SpanEvent;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.api.context.NetworkInfo;
import com.datadog.android.v2.api.context.UserInfo;
import com.datadog.android.v2.core.internal.storage.ContextAwareMapper;
import com.datadog.opentracing.DDSpan;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/tracing/internal/domain/event/DdSpanToSpanEventMapper;", "Lcom/datadog/android/v2/core/internal/storage/ContextAwareMapper;", "Lcom/datadog/opentracing/DDSpan;", "Lcom/datadog/android/tracing/model/SpanEvent;", "()V", "map", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "model", "resolveMeta", "Lcom/datadog/android/tracing/model/SpanEvent$Meta;", "event", "resolveMetrics", "Lcom/datadog/android/tracing/model/SpanEvent$Metrics;", "resolveSimCarrier", "Lcom/datadog/android/tracing/model/SpanEvent$SimCarrier;", "networkInfo", "Lcom/datadog/android/v2/api/context/NetworkInfo;", "dd-sdk-android_release"})
public final class DdSpanToSpanEventMapper
implements ContextAwareMapper<DDSpan, SpanEvent> {
    @Override
    @NotNull
    public SpanEvent map(@NotNull DatadogContext datadogContext, @NotNull DDSpan model) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        long serverOffset = datadogContext.getTime().getServerTimeOffsetNs();
        SpanEvent.Metrics metrics = this.resolveMetrics(model);
        SpanEvent.Meta metadata = this.resolveMeta(datadogContext, model);
        Object object = model.getTraceId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"model.traceId");
        String string = NumberExtKt.toHexString((BigInteger)object);
        Object object2 = model.getSpanId();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"model.spanId");
        object = NumberExtKt.toHexString((BigInteger)object2);
        Object object3 = model.getParentId();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"model.parentId");
        object2 = NumberExtKt.toHexString((BigInteger)object3);
        object3 = model.getResourceName();
        String string2 = model.getOperationName();
        String string3 = model.getServiceName();
        long l = model.getDurationNano();
        long l2 = model.getStartTime() + serverOffset;
        Boolean bl = model.isError();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"model.isError");
        long l3 = bl != false ? 1L : 0L;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"resourceName");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"operationName");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"serviceName");
        return new SpanEvent(string, (String)object, (String)object2, (String)object3, string2, string3, l, l2, l3, metrics, metadata);
    }

    private final SpanEvent.Metrics resolveMetrics(DDSpan event) {
        Long l = event.getParentId().longValue() == 0L ? Long.valueOf(1L) : null;
        Map<String, Number> map = event.getMetrics();
        Intrinsics.checkNotNullExpressionValue(map, (String)"event.metrics");
        return new SpanEvent.Metrics(l, map);
    }

    private final SpanEvent.Meta resolveMeta(DatadogContext datadogContext, DDSpan event) {
        NetworkInfo networkInfo = datadogContext.getNetworkInfo();
        SpanEvent.SimCarrier simCarrier = this.resolveSimCarrier(networkInfo);
        Long l = networkInfo.getStrength();
        Long l2 = networkInfo.getDownKbps();
        Long l3 = networkInfo.getUpKbps();
        SpanEvent.Client networkInfoClient = new SpanEvent.Client(simCarrier, (String)(l == null ? null : l.toString()), (String)(l2 == null ? null : l2.toString()), (String)(l3 == null ? null : l3.toString()), networkInfo.getConnectivity().toString());
        SpanEvent.Network networkInfoMeta = new SpanEvent.Network(networkInfoClient);
        UserInfo userInfo = datadogContext.getUserInfo();
        SpanEvent.Usr usrMeta = new SpanEvent.Usr(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), MapsKt.toMutableMap(userInfo.getAdditionalProperties()));
        String string = datadogContext.getVersion();
        SpanEvent.Dd dd = new SpanEvent.Dd(datadogContext.getSource());
        SpanEvent.Span span = new SpanEvent.Span();
        SpanEvent.Tracer tracer = new SpanEvent.Tracer(datadogContext.getSdkVersion());
        Map<String, String> map = event.getMeta();
        Intrinsics.checkNotNullExpressionValue(map, (String)"event.meta");
        return new SpanEvent.Meta(string, dd, span, tracer, usrMeta, networkInfoMeta, map);
    }

    private final SpanEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        SpanEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            simCarrier = new SpanEvent.SimCarrier((String)(l == null ? null : l.toString()), networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }
}

