/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.domain.event;

import com.datadog.android.core.internal.constraints.DataConstraints;
import com.datadog.android.core.internal.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.tracing.model.SpanEvent;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.storage.ContextAwareSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/tracing/internal/domain/event/SpanEventSerializer;", "Lcom/datadog/android/v2/core/internal/storage/ContextAwareSerializer;", "Lcom/datadog/android/tracing/model/SpanEvent;", "dataConstraints", "Lcom/datadog/android/core/internal/constraints/DataConstraints;", "(Lcom/datadog/android/core/internal/constraints/DataConstraints;)V", "sanitizeKeys", "model", "sanitizeMetrics", "Lcom/datadog/android/tracing/model/SpanEvent$Metrics;", "metrics", "sanitizeUserAttributes", "Lcom/datadog/android/tracing/model/SpanEvent$Usr;", "usr", "serialize", "", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "toMetaString", "element", "", "Companion", "dd-sdk-android_release"})
public final class SpanEventSerializer
implements ContextAwareSerializer<SpanEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataConstraints dataConstraints;
    @NotNull
    public static final String TAG_SPANS = "spans";
    @NotNull
    public static final String TAG_ENV = "env";
    @NotNull
    public static final String META_USR_KEY_PREFIX = "meta.usr";
    @NotNull
    public static final String METRICS_KEY_PREFIX = "metrics";

    public SpanEventSerializer(@NotNull DataConstraints dataConstraints) {
        Intrinsics.checkNotNullParameter((Object)dataConstraints, (String)"dataConstraints");
        this.dataConstraints = dataConstraints;
    }

    public /* synthetic */ SpanEventSerializer(DataConstraints dataConstraints, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dataConstraints = new DatadogDataConstraints();
        }
        this(dataConstraints);
    }

    @Override
    @NotNull
    public String serialize(@NotNull DatadogContext datadogContext, @NotNull SpanEvent model) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        JsonElement span = this.sanitizeKeys(model).toJson();
        JsonArray spans = new JsonArray(1);
        spans.add(span);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(TAG_SPANS, (JsonElement)spans);
        jsonObject.addProperty(TAG_ENV, datadogContext.getEnv());
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        return string;
    }

    private final SpanEvent sanitizeKeys(SpanEvent model) {
        SpanEvent.Usr newUserObject = this.sanitizeUserAttributes(model.getMeta().getUsr());
        SpanEvent.Metrics newMetricsObject = this.sanitizeMetrics(model.getMetrics());
        SpanEvent.Meta meta = SpanEvent.Meta.copy$default(model.getMeta(), null, null, null, null, newUserObject, null, null, 111, null);
        return SpanEvent.copy$default(model, null, null, null, null, null, null, 0L, 0L, 0L, newMetricsObject, meta, 511, null);
    }

    /*
     * WARNING - void declaration
     */
    private final SpanEvent.Usr sanitizeUserAttributes(SpanEvent.Usr usr) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = DataConstraints.DefaultImpls.validateAttributes$default(this.dataConstraints, usr.getAdditionalProperties(), META_USR_KEY_PREFIX, null, null, 12, null);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String string = this.toMetaString(it.getValue());
            map3.put(k, string);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map transformedAttributes = result$iv;
        return SpanEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)transformedAttributes), 7, null);
    }

    private final SpanEvent.Metrics sanitizeMetrics(SpanEvent.Metrics metrics) {
        Map transformedMetrics = DataConstraints.DefaultImpls.validateAttributes$default(this.dataConstraints, metrics.getAdditionalProperties(), METRICS_KEY_PREFIX, null, null, 12, null);
        return SpanEvent.Metrics.copy$default(metrics, null, transformedMetrics, 1, null);
    }

    private final String toMetaString(Object element) {
        Object object = element;
        return Intrinsics.areEqual((Object)object, (Object)MapUtilsKt.getNULL_MAP_VALUE()) ? null : (object == null ? null : (object instanceof Date ? String.valueOf(((Date)element).getTime()) : (object instanceof JsonPrimitive ? ((JsonPrimitive)element).getAsString() : element.toString())));
    }

    public SpanEventSerializer() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/tracing/internal/domain/event/SpanEventSerializer$Companion;", "", "()V", "META_USR_KEY_PREFIX", "", "METRICS_KEY_PREFIX", "TAG_ENV", "TAG_SPANS", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

