/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.tracing.internal.handlers;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.v2.api.FeatureScope;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.LogHandler;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\b2\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J7\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/tracing/internal/handlers/AndroidSpanLogsHandler;", "Lcom/datadog/opentracing/LogHandler;", "sdkCore", "Lcom/datadog/android/v2/api/SdkCore;", "(Lcom/datadog/android/v2/api/SdkCore;)V", "getSdkCore", "()Lcom/datadog/android/v2/api/SdkCore;", "extractError", "", "map", "", "", "span", "Lcom/datadog/opentracing/DDSpan;", "log", "timestampMicroseconds", "", "event", "fields", "", "logFields", "", "(Lcom/datadog/opentracing/DDSpan;Ljava/util/Map;Ljava/lang/Long;)V", "toMilliseconds", "(Ljava/lang/Long;)Ljava/lang/Long;", "Companion", "dd-sdk-android_release"})
public final class AndroidSpanLogsHandler
implements LogHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkCore sdkCore;
    @NotNull
    public static final String DEFAULT_EVENT_MESSAGE = "Span event";
    @NotNull
    public static final String MISSING_LOG_FEATURE_INFO = "Requested to write span log, but Logs feature is not registered.";
    @NotNull
    public static final String TRACE_LOGGER_NAME = "trace";

    public AndroidSpanLogsHandler(@NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.sdkCore = sdkCore;
    }

    @NotNull
    public final SdkCore getSdkCore() {
        return this.sdkCore;
    }

    @Override
    public void log(@NotNull String event, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"event", (Object)event)};
        this.logFields(span, MapsKt.mutableMapOf((Pair[])pairArray), null);
    }

    @Override
    public void log(long timestampMicroseconds, @NotNull String event, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"event", (Object)event)};
        this.logFields(span, MapsKt.mutableMapOf((Pair[])pairArray), timestampMicroseconds);
    }

    @Override
    public void log(@NotNull Map<String, ?> fields, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Map mutableMap = MapsKt.toMutableMap(fields);
        this.extractError(mutableMap, span);
        AndroidSpanLogsHandler.logFields$default(this, span, mutableMap, null, 4, null);
    }

    @Override
    public void log(long timestampMicroseconds, @NotNull Map<String, ?> fields, @NotNull DDSpan span) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Map mutableMap = MapsKt.toMutableMap(fields);
        this.extractError(mutableMap, span);
        this.logFields(span, mutableMap, timestampMicroseconds);
    }

    private final Long toMilliseconds(Long timestampMicroseconds) {
        Long l;
        Long l2 = timestampMicroseconds;
        if (l2 == null) {
            l = null;
        } else {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = TimeUnit.MICROSECONDS.toMillis(it);
        }
        return l;
    }

    private final void logFields(DDSpan span, Map<String, Object> fields, Long timestampMicroseconds) {
        FeatureScope logsFeature = this.sdkCore.getFeature("logs");
        if (logsFeature != null) {
            String string;
            Object object = fields.remove("message");
            if (object == null) {
                string = DEFAULT_EVENT_MESSAGE;
            } else {
                string = object.toString();
                if (string == null) {
                    string = DEFAULT_EVENT_MESSAGE;
                }
            }
            String message = string;
            fields.put("dd.trace_id", span.getTraceId().toString());
            fields.put("dd.span_id", span.getSpanId().toString());
            Long l = this.toMilliseconds(timestampMicroseconds);
            long timestamp = l == null ? System.currentTimeMillis() : l;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"span_log"), TuplesKt.to((Object)"loggerName", (Object)TRACE_LOGGER_NAME), TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"attributes", fields), TuplesKt.to((Object)"timestamp", (Object)timestamp)};
            logsFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.INFO, InternalLogger.Target.USER, MISSING_LOG_FEATURE_INFO, null, 8, null);
        }
    }

    static /* synthetic */ void logFields$default(AndroidSpanLogsHandler androidSpanLogsHandler, DDSpan dDSpan, Map map, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        androidSpanLogsHandler.logFields(dDSpan, map, l);
    }

    private final void extractError(Map<String, ?> map, DDSpan span) {
        String errorType;
        Object kind;
        Object obj = map.remove("error.object");
        Throwable throwable = obj instanceof Throwable ? (Throwable)obj : null;
        Object obj2 = kind = map.remove("error.kind");
        String string = obj2 == null ? null : obj2.toString();
        if (string == null) {
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                string = null;
            } else {
                Class<?> clazz = throwable2.getClass();
                string = clazz == null ? null : clazz.getName();
            }
        }
        if ((errorType = string) != null) {
            Object stackField = map.remove("stack");
            Object msgField = map.get("message");
            Object obj3 = stackField;
            String string2 = obj3 == null ? null : obj3.toString();
            if (string2 == null) {
                Throwable throwable3 = throwable;
                string2 = throwable3 == null ? null : ThrowableExtKt.loggableStackTrace(throwable3);
            }
            String stack = string2;
            Object obj4 = msgField;
            String string3 = obj4 == null ? null : obj4.toString();
            if (string3 == null) {
                Throwable throwable4 = throwable;
                string3 = throwable4 == null ? null : throwable4.getMessage();
            }
            String message = string3;
            span.setError(true);
            span.setTag("error.type", errorType);
            span.setTag("error.msg", message);
            span.setTag("error.stack", stack);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/tracing/internal/handlers/AndroidSpanLogsHandler$Companion;", "", "()V", "DEFAULT_EVENT_MESSAGE", "", "MISSING_LOG_FEATURE_INFO", "TRACE_LOGGER_NAME", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

