/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal.data.upload;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FileReader;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReader;
import com.datadog.android.v2.api.context.DatadogContext;
import com.datadog.android.v2.core.internal.ContextProvider;
import com.datadog.android.v2.core.internal.data.upload.Flusher;
import com.datadog.android.v2.core.internal.net.DataUploader;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/v2/core/internal/data/upload/DataFlusher;", "Lcom/datadog/android/v2/core/internal/data/upload/Flusher;", "contextProvider", "Lcom/datadog/android/v2/core/internal/ContextProvider;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "fileReader", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;", "metadataFileReader", "Lcom/datadog/android/core/internal/persistence/file/FileReader;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "(Lcom/datadog/android/v2/core/internal/ContextProvider;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;Lcom/datadog/android/core/internal/persistence/file/FileReader;Lcom/datadog/android/core/internal/persistence/file/FileMover;)V", "getContextProvider$dd_sdk_android_release", "()Lcom/datadog/android/v2/core/internal/ContextProvider;", "getFileMover$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileMover;", "getFileOrchestrator$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getFileReader$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReader;", "getMetadataFileReader$dd_sdk_android_release", "()Lcom/datadog/android/core/internal/persistence/file/FileReader;", "flush", "", "uploader", "Lcom/datadog/android/v2/core/internal/net/DataUploader;", "dd-sdk-android_release"})
public final class DataFlusher
implements Flusher {
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final FileOrchestrator fileOrchestrator;
    @NotNull
    private final BatchFileReader fileReader;
    @NotNull
    private final FileReader metadataFileReader;
    @NotNull
    private final FileMover fileMover;

    public DataFlusher(@NotNull ContextProvider contextProvider, @NotNull FileOrchestrator fileOrchestrator, @NotNull BatchFileReader fileReader, @NotNull FileReader metadataFileReader, @NotNull FileMover fileMover) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"fileOrchestrator");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter((Object)metadataFileReader, (String)"metadataFileReader");
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        this.contextProvider = contextProvider;
        this.fileOrchestrator = fileOrchestrator;
        this.fileReader = fileReader;
        this.metadataFileReader = metadataFileReader;
        this.fileMover = fileMover;
    }

    @NotNull
    public final ContextProvider getContextProvider$dd_sdk_android_release() {
        return this.contextProvider;
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_release() {
        return this.fileOrchestrator;
    }

    @NotNull
    public final BatchFileReader getFileReader$dd_sdk_android_release() {
        return this.fileReader;
    }

    @NotNull
    public final FileReader getMetadataFileReader$dd_sdk_android_release() {
        return this.metadataFileReader;
    }

    @NotNull
    public final FileMover getFileMover$dd_sdk_android_release() {
        return this.fileMover;
    }

    @Override
    @WorkerThread
    public void flush(@NotNull DataUploader uploader) {
        Intrinsics.checkNotNullParameter((Object)uploader, (String)"uploader");
        DatadogContext context = this.contextProvider.getContext();
        List<File> toUploadFiles = this.fileOrchestrator.getFlushableFiles();
        Iterable $this$forEach$iv = toUploadFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            List<byte[]> batch = this.getFileReader$dd_sdk_android_release().readData(it);
            File metaFile = this.getFileOrchestrator$dd_sdk_android_release().getMetadataFile(it);
            byte[] meta = metaFile != null && FileExtKt.existsSafe(metaFile) ? this.getMetadataFileReader$dd_sdk_android_release().readData(metaFile) : (byte[])null;
            uploader.upload(context, batch, meta);
            this.getFileMover$dd_sdk_android_release().delete(it);
            File file = metaFile;
            if (!(file == null ? false : FileExtKt.existsSafe(file))) continue;
            this.getFileMover$dd_sdk_android_release().delete(metaFile);
        }
    }
}

