/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.v2.core.internal.storage;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.FileWriter;
import com.datadog.android.v2.api.EventBatchWriter;
import com.datadog.android.v2.api.InternalLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0017J\u001a\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0017J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0013H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/v2/core/internal/storage/FileEventBatchWriter;", "Lcom/datadog/android/v2/api/EventBatchWriter;", "batchFile", "Ljava/io/File;", "metadataFile", "eventsWriter", "Lcom/datadog/android/core/internal/persistence/file/FileWriter;", "metadataReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/v2/api/InternalLogger;", "(Ljava/io/File;Ljava/io/File;Lcom/datadog/android/core/internal/persistence/file/FileWriter;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/v2/api/InternalLogger;)V", "checkEventSize", "", "eventSize", "", "currentMetadata", "", "write", "event", "newMetadata", "writeBatchMetadata", "", "metadata", "Companion", "dd-sdk-android_release"})
public final class FileEventBatchWriter
implements EventBatchWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File batchFile;
    @Nullable
    private final File metadataFile;
    @NotNull
    private final FileWriter eventsWriter;
    @NotNull
    private final FileReaderWriter metadataReaderWriter;
    @NotNull
    private final FilePersistenceConfig filePersistenceConfig;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String WARNING_METADATA_WRITE_FAILED = "Unable to write metadata file: %s";
    @NotNull
    public static final String ERROR_LARGE_DATA = "Can't write data with size %d (max item size is %d)";

    public FileEventBatchWriter(@NotNull File batchFile, @Nullable File metadataFile, @NotNull FileWriter eventsWriter, @NotNull FileReaderWriter metadataReaderWriter, @NotNull FilePersistenceConfig filePersistenceConfig, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)batchFile, (String)"batchFile");
        Intrinsics.checkNotNullParameter((Object)eventsWriter, (String)"eventsWriter");
        Intrinsics.checkNotNullParameter((Object)metadataReaderWriter, (String)"metadataReaderWriter");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.batchFile = batchFile;
        this.metadataFile = metadataFile;
        this.eventsWriter = eventsWriter;
        this.metadataReaderWriter = metadataReaderWriter;
        this.filePersistenceConfig = filePersistenceConfig;
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    @Nullable
    public byte[] currentMetadata() {
        if (this.metadataFile == null || !FileExtKt.existsSafe(this.metadataFile)) {
            return null;
        }
        return this.metadataReaderWriter.readData(this.metadataFile);
    }

    @Override
    @WorkerThread
    public boolean write(@NotNull byte[] event, @Nullable byte[] newMetadata) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.length == 0) {
            bl = true;
        } else if (!this.checkEventSize(event.length)) {
            bl = false;
        } else if (this.eventsWriter.writeData(this.batchFile, event, true)) {
            byte[] byArray = newMetadata;
            if ((byArray == null ? false : !(byArray.length == 0)) && this.metadataFile != null) {
                this.writeBatchMetadata(this.metadataFile, newMetadata);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean checkEventSize(int eventSize) {
        if ((long)eventSize > this.filePersistenceConfig.getMaxItemSize()) {
            String string = ERROR_LARGE_DATA;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{eventSize, this.filePersistenceConfig.getMaxItemSize()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, string2, null, 8, null);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final void writeBatchMetadata(File metadataFile, byte[] metadata) {
        boolean result = this.metadataReaderWriter.writeData(metadataFile, metadata, false);
        if (!result) {
            String string = WARNING_METADATA_WRITE_FAILED;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{metadataFile.getPath()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, string2, null, 8, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/v2/core/internal/storage/FileEventBatchWriter$Companion;", "", "()V", "ERROR_LARGE_DATA", "", "WARNING_METADATA_WRITE_FAILED", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

