/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview;

import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import androidx.annotation.MainThread;
import com.datadog.android.Datadog;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.SdkCore;
import com.datadog.android.v2.core.DatadogCore;
import com.datadog.android.webview.internal.MixedWebViewEventConsumer;
import com.datadog.android.webview.internal.NoOpWebViewEventConsumer;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogsFeature;
import com.datadog.android.webview.internal.rum.WebViewRumEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventContextProvider;
import com.datadog.android.webview.internal.rum.WebViewRumFeature;
import com.google.gson.JsonArray;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B#\b\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\u0005H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/webview/DatadogEventBridge;", "", "()V", "allowedHosts", "", "", "(Ljava/util/List;)V", "webViewEventConsumer", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "(Lcom/datadog/android/webview/internal/WebViewEventConsumer;Ljava/util/List;)V", "getWebViewEventConsumer$dd_sdk_android_release", "()Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "getAllowedWebViewHosts", "send", "", "event", "Companion", "dd-sdk-android_release"})
public final class DatadogEventBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebViewEventConsumer<String> webViewEventConsumer;
    @NotNull
    private final List<String> allowedHosts;
    @NotNull
    public static final String JAVA_SCRIPT_NOT_ENABLED_WARNING_MESSAGE = "You are trying to enable the WebViewtracking but the java script capability was not enabled for the given WebView.";
    @NotNull
    public static final String DATADOG_EVENT_BRIDGE_NAME = "DatadogEventBridge";

    public DatadogEventBridge(@NotNull WebViewEventConsumer<String> webViewEventConsumer, @NotNull List<String> allowedHosts) {
        Intrinsics.checkNotNullParameter(webViewEventConsumer, (String)"webViewEventConsumer");
        Intrinsics.checkNotNullParameter(allowedHosts, (String)"allowedHosts");
        this.webViewEventConsumer = webViewEventConsumer;
        this.allowedHosts = allowedHosts;
    }

    @NotNull
    public final WebViewEventConsumer<String> getWebViewEventConsumer$dd_sdk_android_release() {
        return this.webViewEventConsumer;
    }

    public DatadogEventBridge() {
        this(DatadogEventBridge.Companion.buildWebViewEventConsumer(), CollectionsKt.emptyList());
    }

    public DatadogEventBridge(@NotNull List<String> allowedHosts) {
        Intrinsics.checkNotNullParameter(allowedHosts, (String)"allowedHosts");
        this(DatadogEventBridge.Companion.buildWebViewEventConsumer(), allowedHosts);
    }

    @JavascriptInterface
    public final void send(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.webViewEventConsumer.consume(event);
    }

    @JavascriptInterface
    @NotNull
    public final String getAllowedWebViewHosts() {
        CoreFeature coreFeature;
        JsonArray origins = new JsonArray();
        Iterable $this$forEach$iv = this.allowedHosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            origins.add(it);
        }
        SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
        DatadogCore datadogCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
        CoreFeature coreFeature2 = coreFeature = datadogCore == null ? null : datadogCore.getCoreFeature$dd_sdk_android_release();
        if (coreFeature2 != null) {
            List<String> list = coreFeature2.getWebViewTrackingHosts$dd_sdk_android_release();
            if (list != null) {
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    origins.add(it);
                }
            }
        }
        String string = origins.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"origins.toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/webview/DatadogEventBridge$Companion;", "", "()V", "DATADOG_EVENT_BRIDGE_NAME", "", "JAVA_SCRIPT_NOT_ENABLED_WARNING_MESSAGE", "buildWebViewEventConsumer", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "setup", "", "webView", "Landroid/webkit/WebView;", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @MainThread
        public final void setup(@NotNull WebView webView) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            if (!webView.getSettings().getJavaScriptEnabled()) {
                InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, DatadogEventBridge.JAVA_SCRIPT_NOT_ENABLED_WARNING_MESSAGE, null, 8, null);
            }
            webView.addJavascriptInterface((Object)new DatadogEventBridge(), DatadogEventBridge.DATADOG_EVENT_BRIDGE_NAME);
        }

        private final WebViewEventConsumer<String> buildWebViewEventConsumer() {
            DatadogCore datadogCore;
            SdkCore sdkCore = Datadog.INSTANCE.getGlobalSdkCore$dd_sdk_android_release();
            DatadogCore datadogCore2 = datadogCore = sdkCore instanceof DatadogCore ? (DatadogCore)sdkCore : null;
            WebViewRumFeature webViewRumFeature = datadogCore2 == null ? null : datadogCore2.getWebViewRumFeature$dd_sdk_android_release();
            DatadogCore datadogCore3 = datadogCore;
            WebViewLogsFeature webViewLogsFeature = datadogCore3 == null ? null : datadogCore3.getWebViewLogsFeature$dd_sdk_android_release();
            WebViewRumEventContextProvider contextProvider = new WebViewRumEventContextProvider();
            if (webViewLogsFeature == null || webViewRumFeature == null) {
                return new NoOpWebViewEventConsumer();
            }
            return new MixedWebViewEventConsumer(new WebViewRumEventConsumer(datadogCore, webViewRumFeature.getDataWriter$dd_sdk_android_release(), null, contextProvider, 4, null), new WebViewLogEventConsumer(datadogCore, webViewLogsFeature.getDataWriter$dd_sdk_android_release(), contextProvider));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

