/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal;

import androidx.annotation.WorkerThread;
import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.webview.internal.WebViewEventConsumer;
import com.datadog.android.webview.internal.log.WebViewLogEventConsumer;
import com.datadog.android.webview.internal.rum.WebViewRumEventConsumer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00060\u0001\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0017R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00060\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/webview/internal/MixedWebViewEventConsumer;", "Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "", "rumEventConsumer", "Lcom/google/gson/JsonObject;", "logsEventConsumer", "Lkotlin/Pair;", "(Lcom/datadog/android/webview/internal/WebViewEventConsumer;Lcom/datadog/android/webview/internal/WebViewEventConsumer;)V", "getLogsEventConsumer$dd_sdk_android_release", "()Lcom/datadog/android/webview/internal/WebViewEventConsumer;", "getRumEventConsumer$dd_sdk_android_release", "consume", "", "event", "Companion", "dd-sdk-android_release"})
public final class MixedWebViewEventConsumer
implements WebViewEventConsumer<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebViewEventConsumer<JsonObject> rumEventConsumer;
    @NotNull
    private final WebViewEventConsumer<Pair<JsonObject, String>> logsEventConsumer;
    @NotNull
    public static final String EVENT_TYPE_KEY = "eventType";
    @NotNull
    public static final String EVENT_KEY = "event";
    @NotNull
    public static final String LOG_EVENT_TYPE = "log";
    @NotNull
    public static final String WEB_EVENT_PARSING_ERROR_MESSAGE = "We could not deserialize the delegated browser event: %s.";
    @NotNull
    public static final String WEB_EVENT_MISSING_TYPE_ERROR_MESSAGE = "The web event: %s is missing the event type.";
    @NotNull
    public static final String WEB_EVENT_MISSING_WRAPPED_EVENT = "The web event: %s is missing the wrapped event object.";
    @NotNull
    public static final String WRONG_EVENT_TYPE_ERROR_MESSAGE = "The event type %s for the bundled web event is unknown.";

    public MixedWebViewEventConsumer(@NotNull WebViewEventConsumer<JsonObject> rumEventConsumer, @NotNull WebViewEventConsumer<Pair<JsonObject, String>> logsEventConsumer) {
        Intrinsics.checkNotNullParameter(rumEventConsumer, (String)"rumEventConsumer");
        Intrinsics.checkNotNullParameter(logsEventConsumer, (String)"logsEventConsumer");
        this.rumEventConsumer = rumEventConsumer;
        this.logsEventConsumer = logsEventConsumer;
    }

    @NotNull
    public final WebViewEventConsumer<JsonObject> getRumEventConsumer$dd_sdk_android_release() {
        return this.rumEventConsumer;
    }

    @NotNull
    public final WebViewEventConsumer<Pair<JsonObject, String>> getLogsEventConsumer$dd_sdk_android_release() {
        return this.logsEventConsumer;
    }

    @Override
    @WorkerThread
    public void consume(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)EVENT_KEY);
        try {
            JsonObject webEvent = JsonParser.parseString((String)event).getAsJsonObject();
            if (!webEvent.has(EVENT_TYPE_KEY)) {
                InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = WEB_EVENT_MISSING_TYPE_ERROR_MESSAGE;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{event};
                String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                return;
            }
            if (!webEvent.has(EVENT_KEY)) {
                InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                List list = CollectionsKt.listOf((Object[])object);
                object = WEB_EVENT_MISSING_WRAPPED_EVENT;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{event};
                String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, list, string, null, 8, null);
                return;
            }
            String eventType = webEvent.get(EVENT_TYPE_KEY).getAsString();
            JsonObject wrappedEvent = webEvent.get(EVENT_KEY).getAsJsonObject();
            String string = eventType;
            if (WebViewLogEventConsumer.Companion.getLOG_EVENT_TYPES().contains(string)) {
                this.logsEventConsumer.consume((Pair<JsonObject, String>)TuplesKt.to((Object)wrappedEvent, (Object)eventType));
            } else if (WebViewRumEventConsumer.Companion.getRUM_EVENT_TYPES().contains(string)) {
                Intrinsics.checkNotNullExpressionValue((Object)wrappedEvent, (String)"wrappedEvent");
                this.rumEventConsumer.consume(wrappedEvent);
            } else {
                InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
                String string2 = WRONG_EVENT_TYPE_ERROR_MESSAGE;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{eventType};
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, this, *args)");
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, string3, null, 8, null);
            }
        }
        catch (JsonParseException e) {
            InternalLogger internalLogger = RuntimeUtilsKt.getInternalLogger();
            Object object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            List list = CollectionsKt.listOf((Object[])object);
            object = WEB_EVENT_PARSING_ERROR_MESSAGE;
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{event};
            String string = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, this, *args)");
            internalLogger.log(InternalLogger.Level.ERROR, list, string, (Throwable)e);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/webview/internal/MixedWebViewEventConsumer$Companion;", "", "()V", "EVENT_KEY", "", "EVENT_TYPE_KEY", "LOG_EVENT_TYPE", "WEB_EVENT_MISSING_TYPE_ERROR_MESSAGE", "WEB_EVENT_MISSING_WRAPPED_EVENT", "WEB_EVENT_PARSING_ERROR_MESSAGE", "WRONG_EVENT_TYPE_ERROR_MESSAGE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

