/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.webview.internal.rum;

import com.datadog.android.core.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.v2.api.InternalLogger;
import com.datadog.android.v2.api.context.DatadogContext;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider;", "", "()V", "rumFeatureDisabled", "", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "datadogContext", "Lcom/datadog/android/v2/api/context/DatadogContext;", "Companion", "dd-sdk-android_release"})
public final class WebViewRumEventContextProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean rumFeatureDisabled;
    @NotNull
    public static final String RUM_NOT_INITIALIZED_WARNING_MESSAGE = "You are trying to use the WebView tracking API but the RUM feature was not properly initialized.";
    @NotNull
    public static final String RUM_NOT_INITIALIZED_ERROR_MESSAGE = "Trying to consume a bundled rum event but the RUM feature was not yet initialized. Missing the RUM context.";

    @Nullable
    public final RumContext getRumContext(@NotNull DatadogContext datadogContext) {
        RumContext rumContext;
        String rumSessionId;
        Map<String, Object> rumContext2;
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        if (this.rumFeatureDisabled) {
            return null;
        }
        Map<String, Object> map = rumContext2 = datadogContext.getFeaturesContext().get("rum");
        Object object = map == null ? null : map.get("application_id");
        String rumApplicationId = object instanceof String ? (String)object : null;
        Map<String, Object> map2 = rumContext2;
        Object object2 = map2 == null ? null : map2.get("session_id");
        String string = rumSessionId = object2 instanceof String ? (String)object2 : null;
        if (rumApplicationId == null || Intrinsics.areEqual((Object)rumApplicationId, (Object)RumContext.Companion.getNULL_UUID()) || rumSessionId == null || Intrinsics.areEqual((Object)rumSessionId, (Object)RumContext.Companion.getNULL_UUID())) {
            this.rumFeatureDisabled = true;
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.WARN, InternalLogger.Target.USER, RUM_NOT_INITIALIZED_WARNING_MESSAGE, null, 8, null);
            InternalLogger.DefaultImpls.log$default(RuntimeUtilsKt.getInternalLogger(), InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, RUM_NOT_INITIALIZED_ERROR_MESSAGE, null, 8, null);
            rumContext = null;
        } else {
            rumContext = new RumContext(rumApplicationId, rumSessionId, false, null, null, null, null, null, null, 508, null);
        }
        return rumContext;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/webview/internal/rum/WebViewRumEventContextProvider$Companion;", "", "()V", "RUM_NOT_INITIALIZED_ERROR_MESSAGE", "", "RUM_NOT_INITIALIZED_WARNING_MESSAGE", "dd-sdk-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

