/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.exec;

import com.datadog.exec.DaemonThreadFactory;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class CommonTaskExecutor
extends AbstractExecutorService {
    public static final CommonTaskExecutor INSTANCE = new CommonTaskExecutor();
    private static final long SHUTDOWN_WAIT_SECONDS = 5L;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.TASK_SCHEDULER);

    private CommonTaskExecutor() {
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownCallback(this.executorService));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public <T> ScheduledFuture<?> scheduleAtFixedRate(Task<T> task, T target, long initialDelay, long period, TimeUnit unit, String name) {
        if (!INSTANCE.isShutdown()) {
            try {
                PeriodicTask<T> periodicTask = new PeriodicTask<T>(task, target);
                ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(new PeriodicTask<T>(task, target), initialDelay, period, unit);
                periodicTask.setFuture(future);
                return future;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return new UnscheduledFuture(name);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    private static class UnscheduledFuture
    implements ScheduledFuture<Object> {
        private final String name;

        public UnscheduledFuture(String name) {
            this.name = name;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) {
            return null;
        }
    }

    private static class PeriodicTask<T>
    implements Runnable {
        private final WeakReference<T> target;
        private final Task<T> task;
        private volatile ScheduledFuture<?> future = null;

        public PeriodicTask(Task<T> task, T target) {
            this.target = new WeakReference<T>(target);
            this.task = task;
        }

        @Override
        public void run() {
            Object t = this.target.get();
            if (t != null) {
                this.task.run(t);
            } else if (this.future != null) {
                this.future.cancel(false);
            }
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }
    }

    public static interface Task<T> {
        public void run(T var1);
    }

    private static final class ShutdownCallback
    extends Thread {
        private final ScheduledExecutorService executorService;

        private ShutdownCallback(ScheduledExecutorService executorService) {
            super("dd-exec-shutdown-hook");
            this.executorService = executorService;
        }

        @Override
        public void run() {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executorService.shutdownNow();
            }
        }
    }
}

