/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class W3CHttpCodec {
    private static final String TRACEPARENT_KEY = "traceparent";
    private static final String TRACEPARENT_VALUE = "00-0000000000000000%s-%s-0%s";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);
    private static final int HEX_RADIX = 16;

    private W3CHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> tags = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (W3CHttpCodec.TRACEPARENT_KEY.equalsIgnoreCase(key)) {
                        String[] valueParts = value.split("-");
                        if (valueParts.length != 4 || valueParts[0] == "ff") continue;
                        int traceIdLength = valueParts[1].length();
                        if (traceIdLength > 32) {
                            traceId = BigInteger.ZERO;
                            continue;
                        }
                        String trimmedValue = traceIdLength > 16 ? valueParts[1].substring(traceIdLength - 16) : valueParts[1];
                        traceId = HttpCodec.validateUInt64BitsID(trimmedValue, 16);
                        spanId = HttpCodec.validateUInt64BitsID(valueParts[2], 16);
                        samplingPriority = this.convertSamplingPriority(valueParts[3]);
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, null, Collections.emptyMap(), tags);
                    context.lockSamplingPriority();
                    return context;
                }
                if (!tags.isEmpty()) {
                    return new TagContext(null, tags);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return Integer.parseInt(samplingPriority) == 1 ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            try {
                String traceId = context.getTraceId().toString(16).toLowerCase(Locale.US);
                String spanId = context.getSpanId().toString(16).toLowerCase(Locale.US);
                carrier.put(W3CHttpCodec.TRACEPARENT_KEY, String.format(W3CHttpCodec.TRACEPARENT_VALUE, traceId, spanId, this.convertSamplingPriority(context.getSamplingPriority())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

