/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final String PREFIX = "dd.";
    private static final Pattern ENV_REPLACEMENT = Pattern.compile("[^a-zA-Z0-9_]");
    private static final Config INSTANCE = new Config();
    public static final String SERVICE_NAME = "service.name";
    public static final String SERVICE = "service";
    public static final String WRITER_TYPE = "writer.type";
    public static final String AGENT_HOST = "agent.host";
    public static final String TRACE_AGENT_PORT = "trace.agent.port";
    public static final String AGENT_PORT_LEGACY = "agent.port";
    public static final String PRIORITY_SAMPLING = "priority.sampling";
    public static final String TRACE_RESOLVER_ENABLED = "trace.resolver.enabled";
    public static final String SERVICE_MAPPING = "service.mapping";
    public static final String GLOBAL_TAGS = "trace.global.tags";
    public static final String SPAN_TAGS = "trace.span.tags";
    public static final String JMX_TAGS = "trace.jmx.tags";
    public static final String TRACE_ANALYTICS_ENABLED = "trace.analytics.enabled";
    public static final String TRACE_ANNOTATIONS = "trace.annotations";
    public static final String TRACE_METHODS = "trace.methods";
    public static final String HEADER_TAGS = "trace.header.tags";
    public static final String HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN = "trace.http.client.split-by-domain";
    public static final String PARTIAL_FLUSH_MIN_SPANS = "trace.partial.flush.min.spans";
    public static final String RUNTIME_CONTEXT_FIELD_INJECTION = "trace.runtime.context.field.injection";
    public static final String JMX_FETCH_ENABLED = "jmxfetch.enabled";
    public static final String JMX_FETCH_METRICS_CONFIGS = "jmxfetch.metrics-configs";
    public static final String JMX_FETCH_CHECK_PERIOD = "jmxfetch.check-period";
    public static final String JMX_FETCH_REFRESH_BEANS_PERIOD = "jmxfetch.refresh-beans-period";
    public static final String JMX_FETCH_STATSD_HOST = "jmxfetch.statsd.host";
    public static final String JMX_FETCH_STATSD_PORT = "jmxfetch.statsd.port";
    public static final String APP_CUSTOM_LOG_MANAGER = "app.customlogmanager";
    public static final String RUNTIME_ID_TAG = "runtime-id";
    public static final String LANGUAGE_TAG_KEY = "language";
    public static final String LANGUAGE_TAG_VALUE = "jvm";
    public static final String DEFAULT_SERVICE_NAME = "unnamed-java-app";
    public static final String DD_AGENT_WRITER_TYPE = "DDAgentWriter";
    public static final String LOGGING_WRITER_TYPE = "LoggingWriter";
    public static final String DEFAULT_AGENT_WRITER_TYPE = "DDAgentWriter";
    public static final String DEFAULT_AGENT_HOST = "localhost";
    public static final int DEFAULT_TRACE_AGENT_PORT = 8126;
    public static final String LOGS_INJECTION_ENABLED = "logs.injection";
    public static final boolean DEFAULT_LOGS_INJECTION_ENABLED = false;
    private static final boolean DEFAULT_RUNTIME_CONTEXT_FIELD_INJECTION = true;
    private static final boolean DEFAULT_PRIORITY_SAMPLING_ENABLED = true;
    private static final boolean DEFAULT_TRACE_RESOLVER_ENABLED = true;
    private static final boolean DEFAULT_HTTP_CLIENT_SPLIT_BY_DOMAIN = false;
    private static final int DEFAULT_PARTIAL_FLUSH_MIN_SPANS = 0;
    private static final boolean DEFAULT_JMX_FETCH_ENABLED = false;
    public static final int DEFAULT_JMX_FETCH_STATSD_PORT = 8125;
    private static final boolean DEFAULT_APP_CUSTOM_LOG_MANAGER = false;
    private final String runtimeId;
    private final String serviceName;
    private final String writerType;
    private final String agentHost;
    private final int agentPort;
    private final boolean prioritySamplingEnabled;
    private final boolean traceResolverEnabled;
    private final Map<String, String> serviceMapping;
    private final Map<String, String> globalTags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final Map<String, String> headerTags;
    private final boolean httpClientSplitByDomain;
    private final Integer partialFlushMinSpans;
    private final boolean runtimeContextFieldInjection;
    private final boolean jmxFetchEnabled;
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean logsInjectionEnabled;
    private final boolean appCustomLogManager;

    Config() {
        this.runtimeId = UUID.randomUUID().toString();
        this.serviceName = Config.getSettingFromEnvironment(SERVICE_NAME, DEFAULT_SERVICE_NAME);
        this.writerType = Config.getSettingFromEnvironment(WRITER_TYPE, "DDAgentWriter");
        this.agentHost = Config.getSettingFromEnvironment(AGENT_HOST, DEFAULT_AGENT_HOST);
        this.agentPort = Config.getIntegerSettingFromEnvironment(TRACE_AGENT_PORT, Config.getIntegerSettingFromEnvironment(AGENT_PORT_LEGACY, 8126));
        this.prioritySamplingEnabled = Config.getBooleanSettingFromEnvironment(PRIORITY_SAMPLING, true);
        this.traceResolverEnabled = Config.getBooleanSettingFromEnvironment(TRACE_RESOLVER_ENABLED, true);
        this.serviceMapping = Config.getMapSettingFromEnvironment(SERVICE_MAPPING, null);
        this.globalTags = Config.getMapSettingFromEnvironment(GLOBAL_TAGS, null);
        this.spanTags = Config.getMapSettingFromEnvironment(SPAN_TAGS, null);
        this.jmxTags = Config.getMapSettingFromEnvironment(JMX_TAGS, null);
        this.headerTags = Config.getMapSettingFromEnvironment(HEADER_TAGS, null);
        this.httpClientSplitByDomain = Config.getBooleanSettingFromEnvironment(HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, false);
        this.partialFlushMinSpans = Config.getIntegerSettingFromEnvironment(PARTIAL_FLUSH_MIN_SPANS, 0);
        this.runtimeContextFieldInjection = Config.getBooleanSettingFromEnvironment(RUNTIME_CONTEXT_FIELD_INJECTION, true);
        this.jmxFetchEnabled = Config.getBooleanSettingFromEnvironment(JMX_FETCH_ENABLED, false);
        this.jmxFetchMetricsConfigs = Config.getListSettingFromEnvironment(JMX_FETCH_METRICS_CONFIGS, null);
        this.jmxFetchCheckPeriod = Config.getIntegerSettingFromEnvironment(JMX_FETCH_CHECK_PERIOD, null);
        this.jmxFetchRefreshBeansPeriod = Config.getIntegerSettingFromEnvironment(JMX_FETCH_REFRESH_BEANS_PERIOD, null);
        this.jmxFetchStatsdHost = Config.getSettingFromEnvironment(JMX_FETCH_STATSD_HOST, null);
        this.jmxFetchStatsdPort = Config.getIntegerSettingFromEnvironment(JMX_FETCH_STATSD_PORT, 8125);
        this.logsInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOGS_INJECTION_ENABLED, false);
        this.appCustomLogManager = Config.getBooleanSettingFromEnvironment(APP_CUSTOM_LOG_MANAGER, false);
    }

    private Config(Properties properties, Config parent) {
        this.runtimeId = parent.runtimeId;
        this.serviceName = properties.getProperty(SERVICE_NAME, parent.serviceName);
        this.writerType = properties.getProperty(WRITER_TYPE, parent.writerType);
        this.agentHost = properties.getProperty(AGENT_HOST, parent.agentHost);
        this.agentPort = Config.getPropertyIntegerValue(properties, TRACE_AGENT_PORT, Config.getPropertyIntegerValue(properties, AGENT_PORT_LEGACY, parent.agentPort));
        this.prioritySamplingEnabled = Config.getPropertyBooleanValue(properties, PRIORITY_SAMPLING, parent.prioritySamplingEnabled);
        this.traceResolverEnabled = Config.getPropertyBooleanValue(properties, TRACE_RESOLVER_ENABLED, parent.traceResolverEnabled);
        this.serviceMapping = Config.getPropertyMapValue(properties, SERVICE_MAPPING, parent.serviceMapping);
        this.globalTags = Config.getPropertyMapValue(properties, GLOBAL_TAGS, parent.globalTags);
        this.spanTags = Config.getPropertyMapValue(properties, SPAN_TAGS, parent.spanTags);
        this.jmxTags = Config.getPropertyMapValue(properties, JMX_TAGS, parent.jmxTags);
        this.headerTags = Config.getPropertyMapValue(properties, HEADER_TAGS, parent.headerTags);
        this.httpClientSplitByDomain = Config.getPropertyBooleanValue(properties, HTTP_CLIENT_HOST_SPLIT_BY_DOMAIN, parent.httpClientSplitByDomain);
        this.partialFlushMinSpans = Config.getPropertyIntegerValue(properties, PARTIAL_FLUSH_MIN_SPANS, parent.partialFlushMinSpans);
        this.runtimeContextFieldInjection = Config.getPropertyBooleanValue(properties, RUNTIME_CONTEXT_FIELD_INJECTION, parent.runtimeContextFieldInjection);
        this.jmxFetchEnabled = Config.getPropertyBooleanValue(properties, JMX_FETCH_ENABLED, parent.jmxFetchEnabled);
        this.jmxFetchMetricsConfigs = Config.getPropertyListValue(properties, JMX_FETCH_METRICS_CONFIGS, parent.jmxFetchMetricsConfigs);
        this.jmxFetchCheckPeriod = Config.getPropertyIntegerValue(properties, JMX_FETCH_CHECK_PERIOD, parent.jmxFetchCheckPeriod);
        this.jmxFetchRefreshBeansPeriod = Config.getPropertyIntegerValue(properties, JMX_FETCH_REFRESH_BEANS_PERIOD, parent.jmxFetchRefreshBeansPeriod);
        this.jmxFetchStatsdHost = properties.getProperty(JMX_FETCH_STATSD_HOST, parent.jmxFetchStatsdHost);
        this.jmxFetchStatsdPort = Config.getPropertyIntegerValue(properties, JMX_FETCH_STATSD_PORT, parent.jmxFetchStatsdPort);
        this.logsInjectionEnabled = Config.getBooleanSettingFromEnvironment(LOGS_INJECTION_ENABLED, false);
        this.appCustomLogManager = Config.getBooleanSettingFromEnvironment(APP_CUSTOM_LOG_MANAGER, false);
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.globalTags.size() + this.spanTags.size());
        result.putAll(this.globalTags);
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.globalTags.size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.globalTags);
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put(SERVICE, this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getRuntimeTags() {
        Map<String, String> result = Config.newHashMap(2);
        result.put(RUNTIME_ID_TAG, this.runtimeId);
        result.put(LANGUAGE_TAG_KEY, LANGUAGE_TAG_VALUE);
        return Collections.unmodifiableMap(result);
    }

    public static boolean integrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment("integration." + name + ".enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            boolean configEnabled = Config.getBooleanSettingFromEnvironment(name + ".analytics.enabled", defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public static String getSettingFromEnvironment(String name, String defaultValue) {
        String completeName = PREFIX + name;
        String value = System.getProperties().getProperty(completeName, System.getenv(Config.propertyToEnvironmentName(completeName)));
        return value == null ? defaultValue : value;
    }

    private static Map<String, String> getMapSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseMap(Config.getSettingFromEnvironment(name, defaultValue), PREFIX + name);
    }

    private static List<String> getListSettingFromEnvironment(String name, String defaultValue) {
        return Config.parseList(Config.getSettingFromEnvironment(name, defaultValue));
    }

    public static Boolean getBooleanSettingFromEnvironment(String name, Boolean defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        return value == null || value.trim().isEmpty() ? defaultValue : Boolean.valueOf(value);
    }

    public static Float getFloatSettingFromEnvironment(String name, Float defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, (Throwable)e);
            return defaultValue;
        }
    }

    private static Integer getIntegerSettingFromEnvironment(String name, Integer defaultValue) {
        String value = Config.getSettingFromEnvironment(name, null);
        try {
            return value == null ? defaultValue : Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + name, (Throwable)e);
            return defaultValue;
        }
    }

    private static String propertyToEnvironmentName(String name) {
        return ENV_REPLACEMENT.matcher(name.toUpperCase()).replaceAll("_");
    }

    private static Map<String, String> getPropertyMapValue(Properties properties, String name, Map<String, String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseMap(value, name);
    }

    private static List<String> getPropertyListValue(Properties properties, String name, List<String> defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Config.parseList(value);
    }

    private static Boolean getPropertyBooleanValue(Properties properties, String name, Boolean defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Boolean.valueOf(value);
    }

    private static Integer getPropertyIntegerValue(Properties properties, String name, Integer defaultValue) {
        String value = properties.getProperty(name);
        return value == null || value.trim().isEmpty() ? defaultValue : Integer.valueOf(value);
    }

    private static Map<String, String> parseMap(String str, String settingName) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        if (!str.matches("(([^,:]+:[^,:]*,)*([^,:]+:[^,:]*),?)?")) {
            log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2'.", (Object)settingName, (Object)str);
            return Collections.emptyMap();
        }
        String[] tokens = str.split(",", -1);
        Map<String, String> map = Config.newHashMap(tokens.length);
        for (String token : tokens) {
            String[] keyValue = token.split(":", -1);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            if (value.length() <= 0) {
                log.warn("Ignoring empty value for key '{}' in config for {}", (Object)key, (Object)settingName);
                continue;
            }
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    private static List<String> parseList(String str) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = str.split(",", -1);
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    public static Config get() {
        return INSTANCE;
    }

    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(properties, INSTANCE);
    }

    public String toString() {
        return "Config(runtimeId=" + this.getRuntimeId() + ", serviceName=" + this.getServiceName() + ", writerType=" + this.getWriterType() + ", agentHost=" + this.getAgentHost() + ", agentPort=" + this.getAgentPort() + ", prioritySamplingEnabled=" + this.isPrioritySamplingEnabled() + ", traceResolverEnabled=" + this.isTraceResolverEnabled() + ", serviceMapping=" + this.getServiceMapping() + ", globalTags=" + this.globalTags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", headerTags=" + this.getHeaderTags() + ", httpClientSplitByDomain=" + this.isHttpClientSplitByDomain() + ", partialFlushMinSpans=" + this.getPartialFlushMinSpans() + ", runtimeContextFieldInjection=" + this.isRuntimeContextFieldInjection() + ", jmxFetchEnabled=" + this.isJmxFetchEnabled() + ", jmxFetchMetricsConfigs=" + this.getJmxFetchMetricsConfigs() + ", jmxFetchCheckPeriod=" + this.getJmxFetchCheckPeriod() + ", jmxFetchRefreshBeansPeriod=" + this.getJmxFetchRefreshBeansPeriod() + ", jmxFetchStatsdHost=" + this.getJmxFetchStatsdHost() + ", jmxFetchStatsdPort=" + this.getJmxFetchStatsdPort() + ", logsInjectionEnabled=" + this.isLogsInjectionEnabled() + ", appCustomLogManager=" + this.isAppCustomLogManager() + ")";
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public Integer getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isAppCustomLogManager() {
        return this.appCustomLogManager;
    }
}

