/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Tracer;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.context.ScopeListener;
import java.util.concurrent.atomic.AtomicReference;

public class GlobalTracer {
    private static final Tracer NO_OP = new Tracer(){

        @Override
        public String getTraceId() {
            return "0";
        }

        @Override
        public String getSpanId() {
            return "0";
        }

        @Override
        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }

        @Override
        public void addScopeListener(ScopeListener listener) {
        }
    };
    private static final AtomicReference<Tracer> provider = new AtomicReference<Tracer>(NO_OP);
    private static final AtomicReference<Callback> installationCallback = new AtomicReference<Object>(null);

    public static void registerIfAbsent(Tracer p) {
        Callback callback;
        boolean installed;
        if (p != null && p != NO_OP && (installed = provider.compareAndSet(NO_OP, p)) && (callback = (Callback)installationCallback.getAndSet(null)) != null) {
            callback.installed(p);
        }
    }

    public static Tracer get() {
        return provider.get();
    }

    static boolean isTracerInstalled() {
        return provider.get() != NO_OP;
    }

    static boolean isCallbackInstalled() {
        return installationCallback.get() != null;
    }

    static boolean registerInstallationCallback(Callback callback) {
        if (!GlobalTracer.isTracerInstalled()) {
            boolean installed = installationCallback.compareAndSet(null, callback);
            if (installed && GlobalTracer.isTracerInstalled()) {
                installed = !installationCallback.compareAndSet(callback, null);
            }
            return installed;
        }
        return false;
    }

    static interface Callback {
        public void installed(Tracer var1);
    }
}

