/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class DDId {
    public static final DDId ZERO = new DDId(0L, "0");
    public static final DDId MAX = new DDId(-1L, "18446744073709551615");
    private static final DDId ONE = DDId.from(1L);
    private final long id;
    private String str;
    private static long MAX_FIRST_PART = 0x1999999999999999L;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static DDId from(long id) {
        return DDId.create(id, null);
    }

    public static DDId from(String s) throws NumberFormatException {
        return DDId.create(DDId.parseUnsignedLong(s), s);
    }

    public static DDId fromHex(String s) throws NumberFormatException {
        return DDId.create(DDId.parseUnsignedLongHex(s), null);
    }

    public static DDId fromHexWithOriginal(String s) throws NumberFormatException {
        return new DDIdOriginal(DDId.parseUnsignedLongHex(s), s);
    }

    public static DDId fromHexTruncatedWithOriginal(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        int trimmed = Math.min(s.length(), 16);
        return new DDIdOriginal(DDId.parseUnsignedLongHex(s, len - trimmed, trimmed), s);
    }

    private DDId(long id, String str) {
        this.id = id;
        this.str = str;
    }

    private static DDId create(long id, String str) {
        if (id == 0L) {
            return ZERO;
        }
        if (id == -1L) {
            return MAX;
        }
        return new DDId(id, str);
    }

    private static int firstNonZeroCharacter(String s, int start) {
        int firstNonZero;
        for (firstNonZero = start; firstNonZero < s.length() && s.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        return firstNonZero;
    }

    private static NumberFormatException numberFormatOutOfRange(String s) {
        return new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    private static long parseUnsignedLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 18) {
                return Long.parseLong(s);
            }
            if (len > 20) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long first = 0L;
            int ok = 0;
            for (int i = 0; i < len - 1; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 10);
                ok |= d;
                first = first * 10L + (long)d;
            }
            int last = Character.digit(s.charAt(len - 1), 10);
            if ((ok |= last) < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            if (first > MAX_FIRST_PART) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long guard = first * 10L;
            long result = guard + (long)last;
            if (guard < 0L && result >= 0L) {
                throw DDId.numberFormatOutOfRange(s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static long parseUnsignedLongHex(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        return DDId.parseUnsignedLongHex(s, 0, s.length());
    }

    private static long parseUnsignedLongHex(String s, int start, int len) throws NumberFormatException {
        if (len > 0) {
            if (len > 16 && len - DDId.firstNonZeroCharacter(s, start) > 16) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long result = 0L;
            int ok = 0;
            int i = 0;
            while (i < len) {
                char c = s.charAt(start);
                int d = Character.digit(c, 16);
                ok |= d;
                result = result << 4 | (long)d;
                ++i;
                ++start;
            }
            if (ok < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        long quot = (l >>> 1) / 5L;
        long rem = l - quot * 10L;
        return Long.toString(quot) + rem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DDId)) {
            return false;
        }
        DDId ddId = (DDId)o;
        return this.id == ddId.id;
    }

    public int hashCode() {
        long id = this.id;
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        String s = this.str;
        if (s == null) {
            this.str = s = DDId.toUnsignedString(this.id);
        }
        return s;
    }

    public String toHexString() {
        return Long.toHexString(this.id);
    }

    public String toHexStringPadded(int size) {
        if (size > 16) {
            size = 32;
        } else if (size < 16) {
            size = 16;
        }
        byte[] bytes = new byte[size];
        long remaining = this.id;
        int nibbleCount = Long.numberOfLeadingZeros(remaining) >>> 2;
        Arrays.fill(bytes, 0, size - 16 + nibbleCount, (byte)48);
        for (int i = 0; i < 16 - nibbleCount; ++i) {
            int b = (int)(remaining & 0xFL);
            bytes[size - 1 - i] = HEX_DIGITS[b];
            remaining >>>= 4;
        }
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public String toHexStringOrOriginal() {
        return this.toHexString();
    }

    public long toLong() {
        return this.id;
    }

    private static final class DDIdOriginal
    extends DDId {
        private final String original;

        private DDIdOriginal(long id, String original) {
            super(id, null);
            this.original = original;
        }

        @Override
        public String toHexStringOrOriginal() {
            return this.original;
        }
    }
}

