/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.internal.util.HexStringUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class DDId {
    private static final long MAX_FIRST_PART = 0x1999999999999999L;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private DDId() {
    }

    static long parseUnsignedLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 18) {
                return Long.parseLong(s);
            }
            if (len > 20) {
                throw HexStringUtils.numberFormatOutOfLongRange(s);
            }
            long first = 0L;
            int ok = 0;
            for (int i = 0; i < len - 1; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 10);
                ok |= d;
                first = first * 10L + (long)d;
            }
            int last = Character.digit(s.charAt(len - 1), 10);
            if ((ok |= last) < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            if (first > 0x1999999999999999L) {
                throw HexStringUtils.numberFormatOutOfLongRange(s);
            }
            long guard = first * 10L;
            long result = guard + (long)last;
            if (guard < 0L && result >= 0L) {
                throw HexStringUtils.numberFormatOutOfLongRange(s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    static long parseUnsignedLongHex(String s) throws NumberFormatException {
        return HexStringUtils.parseUnsignedLongHex(s, 0, s == null ? 0 : s.length(), false);
    }

    static String toHexStringPadded(long id, int size) {
        if (size > 16) {
            size = 32;
        } else if (size < 16) {
            size = 16;
        }
        byte[] bytes = new byte[size];
        long remaining = id;
        int nibbleCount = Long.numberOfLeadingZeros(remaining) >>> 2;
        Arrays.fill(bytes, 0, size - 16 + nibbleCount, (byte)48);
        for (int i = 0; i < 16 - nibbleCount; ++i) {
            int b = (int)(remaining & 0xFL);
            bytes[size - 1 - i] = HEX_DIGITS[b];
            remaining >>>= 4;
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

