/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.internal.util;

public class HexStringUtils {
    private HexStringUtils() {
    }

    public static long parseUnsignedLongHex(String s, int start, int len, boolean lowerCaseOnly) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (len > 0 && start >= 0 && start + len <= s.length()) {
            if (len > 16 && len - HexStringUtils.firstNonZeroCharacter(s, start) > 16) {
                throw HexStringUtils.numberFormatOutOfLongRange(s);
            }
            long result = 0L;
            int ok = 0;
            int i = 0;
            while (i < len && ok >= 0) {
                char c = s.charAt(start);
                int d = Character.digit(c, 16);
                if (lowerCaseOnly && Character.isUpperCase(c)) {
                    ok = -1;
                }
                ok |= d;
                result = result << 4 | (long)d;
                ++i;
                ++start;
            }
            if (ok < 0) {
                throw new NumberFormatException("Illegal character in " + s.substring(start, len));
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    private static int firstNonZeroCharacter(String s, int start) {
        int firstNonZero;
        for (firstNonZero = start; firstNonZero < s.length() && s.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        return firstNonZero;
    }

    public static NumberFormatException numberFormatOutOfLongRange(String s) {
        return new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }
}

