/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.internal.InternalTracer;
import datadog.trace.api.internal.TraceSegment;
import java.util.Map;

public class EventTracker {
    public static final EventTracker NO_EVENT_TRACKER = new EventTracker(null);
    private final InternalTracer tracer;

    EventTracker(InternalTracer tracer) {
        this.tracer = tracer;
    }

    public void trackLoginSuccessEvent(String userId, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("UserId is null or empty");
        }
        TraceSegment segment = this.getTraceSegment();
        if (segment == null) {
            return;
        }
        segment.setTagTop("appsec.events.users.login.success.track", true);
        segment.setTagTop("usr.id", userId);
        segment.setTagTop("manual.keep", true);
        if (metadata != null && !metadata.isEmpty()) {
            segment.setTagTop("appsec.events.users.login.success", metadata);
        }
    }

    public void trackLoginFailureEvent(String userId, boolean exists, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("UserId is null or empty");
        }
        if (this.tracer == null) {
            return;
        }
        TraceSegment segment = this.getTraceSegment();
        if (segment == null) {
            return;
        }
        segment.setTagTop("appsec.events.users.login.failure.track", true);
        segment.setTagTop("appsec.events.users.login.failure.usr.id", userId);
        segment.setTagTop("appsec.events.users.login.failure.usr.exists", exists);
        segment.setTagTop("manual.keep", true);
        if (metadata != null && !metadata.isEmpty()) {
            segment.setTagTop("appsec.events.users.login.failure", metadata);
        }
    }

    public void trackCustomEvent(String eventName, Map<String, String> metadata) {
        if (eventName == null || eventName.isEmpty()) {
            throw new IllegalArgumentException("EventName is null or empty");
        }
        if (this.tracer == null) {
            return;
        }
        TraceSegment segment = this.getTraceSegment();
        if (segment == null) {
            return;
        }
        segment.setTagTop("appsec.events." + eventName + ".track", true, true);
        segment.setTagTop("manual.keep", true);
        if (metadata != null && !metadata.isEmpty()) {
            segment.setTagTop("appsec.events." + eventName, metadata, true);
        }
    }

    private TraceSegment getTraceSegment() {
        if (this.tracer == null) {
            return null;
        }
        return this.tracer.getTraceSegment();
    }
}

