/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.common.writer.DDApi;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.WriterQueue;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(DDAgentWriter.class);
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 8126;
    static final int DEFAULT_MAX_TRACES = 7000;
    static final long API_TIMEOUT_SECONDS = 1L;
    static final long FLUSH_TIME_SECONDS = 1L;
    private final ThreadFactory agentWriterThreadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "dd-agent-writer");
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, this.agentWriterThreadFactory);
    private final ExecutorService executor = Executors.newSingleThreadExecutor(this.agentWriterThreadFactory);
    private final DDApi api;
    private final WriterQueue<List<DDSpan>> traces;
    private boolean queueFullReported = false;

    public DDAgentWriter() {
        this(new DDApi(DEFAULT_HOSTNAME, 8126));
    }

    public DDAgentWriter(DDApi api) {
        this(api, new WriterQueue<List<DDSpan>>(7000));
    }

    public DDAgentWriter(DDApi api, WriterQueue<List<DDSpan>> queue) {
        this.api = api;
        this.traces = queue;
    }

    @Override
    public void write(List<DDSpan> trace) {
        List<DDSpan> removed = this.traces.add(trace);
        if (removed != null && !this.queueFullReported) {
            log.debug("Queue is full, traces will be discarded, queue size: {}", (Object)7000);
            this.queueFullReported = true;
            return;
        }
        this.queueFullReported = false;
    }

    @Override
    public void start() {
        this.scheduledExecutor.scheduleAtFixedRate(new TracesSendingTask(), 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.scheduledExecutor.shutdownNow();
        this.executor.shutdownNow();
        try {
            this.scheduledExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.info("Writer properly closed and async writer interrupted.");
        }
        try {
            this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.info("Writer properly closed and async writer interrupted.");
        }
    }

    public String toString() {
        return "DDAgentWriter { api=" + this.api + " }";
    }

    public DDApi getApi() {
        return this.api;
    }

    class TracesSendingTask
    implements Runnable {
        TracesSendingTask() {
        }

        @Override
        public void run() {
            Future<Long> future = DDAgentWriter.this.executor.submit(new SendingTask());
            try {
                long nbTraces = future.get(1L, TimeUnit.SECONDS);
                if (nbTraces > 0L) {
                    log.debug("Successfully sent {} traces to the API", (Object)nbTraces);
                }
            }
            catch (TimeoutException e) {
                log.debug("Timeout! Failed to send traces to the API: {}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                log.debug("Failed to send traces to the API: {}", (Object)e.getMessage());
            }
        }

        class SendingTask
        implements Callable<Long> {
            SendingTask() {
            }

            @Override
            public Long call() throws Exception {
                boolean isSent;
                if (DDAgentWriter.this.traces.isEmpty()) {
                    return 0L;
                }
                List<List<DDSpan>> payload = DDAgentWriter.this.traces.getAll();
                if (log.isDebugEnabled()) {
                    int nbSpans = 0;
                    for (List list : payload) {
                        nbSpans += list.size();
                    }
                    log.debug("Sending {} traces ({} spans) to the API (async)", (Object)payload.size(), (Object)nbSpans);
                }
                if (!(isSent = DDAgentWriter.this.api.sendTraces(payload))) {
                    log.debug("Failing to send {} traces to the API", (Object)payload.size());
                    return 0L;
                }
                return payload.size();
            }
        }
    }
}

