/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.opentracing.DDSpan;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.DDApi;
import datadog.trace.common.writer.LoggingWriter;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Writer {
    public static final String DD_AGENT_WRITER_TYPE = DDAgentWriter.class.getSimpleName();
    public static final String LOGGING_WRITER_TYPE = LoggingWriter.class.getSimpleName();

    public void write(List<DDSpan> var1);

    public void start();

    public void close();

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);

        public static Writer forConfig(Properties config) {
            Writer writer;
            if (config != null) {
                String configuredType = config.getProperty("writer.type");
                if (DD_AGENT_WRITER_TYPE.equals(configuredType)) {
                    writer = new DDAgentWriter(new DDApi(config.getProperty("agent.host"), Integer.parseInt(config.getProperty("agent.port"))));
                } else if (LOGGING_WRITER_TYPE.equals(configuredType)) {
                    writer = new LoggingWriter();
                } else {
                    log.warn("Writer type not configured correctly: Type {} not recognized. Defaulting to DDAgentWriter.", (Object)configuredType);
                    writer = new DDAgentWriter(new DDApi(config.getProperty("agent.host"), Integer.parseInt(config.getProperty("agent.port"))));
                }
            } else {
                log.warn("Writer type not configured correctly: No config provided! Defaulting to DDAgentWriter.");
                writer = new DDAgentWriter();
            }
            return writer;
        }

        private Builder() {
        }
    }
}

