/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.PropagationStyle;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.B3HttpCodec;
import datadog.trace.core.propagation.DatadogHttpCodec;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HaystackHttpCodec;
import datadog.trace.core.propagation.XRayHttpCodec;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HttpCodec.class);
    static final String FORWARDED_KEY = "forwarded";
    static final String X_FORWARDED_PROTO_KEY = "x-forwarded-proto";
    static final String X_FORWARDED_HOST_KEY = "x-forwarded-host";
    static final String X_FORWARDED_FOR_KEY = "x-forwarded-for";
    static final String X_FORWARDED_PORT_KEY = "x-forwarded-port";

    public static <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter, PropagationStyle style) {
        switch (style) {
            case DATADOG: {
                DatadogHttpCodec.INJECTOR.inject(context, carrier, setter);
                break;
            }
            case B3: {
                B3HttpCodec.INJECTOR.inject(context, carrier, setter);
                break;
            }
            case HAYSTACK: {
                HaystackHttpCodec.INJECTOR.inject(context, carrier, setter);
                break;
            }
            case XRAY: {
                XRayHttpCodec.INJECTOR.inject(context, carrier, setter);
                break;
            }
            default: {
                log.debug("No implementation found to inject propagation style: {}", (Object)style);
            }
        }
    }

    public static Injector createInjector(Config config) {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        block6: for (PropagationStyle style : config.getPropagationStylesToInject()) {
            switch (style) {
                case DATADOG: {
                    injectors.add(DatadogHttpCodec.INJECTOR);
                    continue block6;
                }
                case B3: {
                    injectors.add(B3HttpCodec.INJECTOR);
                    continue block6;
                }
                case HAYSTACK: {
                    injectors.add(HaystackHttpCodec.INJECTOR);
                    continue block6;
                }
                case XRAY: {
                    injectors.add(XRayHttpCodec.INJECTOR);
                    continue block6;
                }
            }
            log.debug("No implementation found to inject propagation style: {}", (Object)style);
        }
        return new CompoundInjector(injectors);
    }

    public static Extractor createExtractor(Config config, Map<String, String> taggedHeaders) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        block6: for (PropagationStyle style : config.getPropagationStylesToExtract()) {
            switch (style) {
                case DATADOG: {
                    extractors.add(DatadogHttpCodec.newExtractor(taggedHeaders));
                    continue block6;
                }
                case B3: {
                    extractors.add(B3HttpCodec.newExtractor(taggedHeaders));
                    continue block6;
                }
                case HAYSTACK: {
                    extractors.add(HaystackHttpCodec.newExtractor(taggedHeaders));
                    continue block6;
                }
                case XRAY: {
                    extractors.add(XRayHttpCodec.newExtractor(taggedHeaders));
                    continue block6;
                }
            }
            log.debug("No implementation found to extract propagation style: {}", (Object)style);
        }
        return new CompoundExtractor(extractors);
    }

    static String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    static String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }

    static String firstHeaderValue(String value) {
        if (value == null) {
            return null;
        }
        int firstComma = value.indexOf(44);
        return firstComma == -1 ? value : value.substring(0, firstComma).trim();
    }

    public static class CompoundExtractor
    implements Extractor {
        private final List<Extractor> extractors;

        public CompoundExtractor(List<Extractor> extractors) {
            this.extractors = extractors;
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            TagContext context = null;
            for (Extractor extractor : this.extractors) {
                context = extractor.extract(carrier, getter);
                if (!(context instanceof ExtractedContext)) continue;
                return context;
            }
            return context;
        }
    }

    public static class CompoundInjector
    implements Injector {
        private final List<Injector> injectors;

        public CompoundInjector(List<Injector> injectors) {
            this.injectors = injectors;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            for (Injector injector : this.injectors) {
                injector.inject(context, carrier, setter);
            }
        }
    }

    public static interface Extractor {
        public <C> TagContext extract(C var1, AgentPropagation.ContextVisitor<C> var2);
    }

    public static interface Injector {
        public <C> void inject(DDSpanContext var1, C var2, AgentPropagation.Setter<C> var3);
    }
}

