/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.communication.ddagent.DroppingPolicy;
import datadog.communication.http.RetryPolicy;
import datadog.communication.monitor.Monitoring;
import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.WellKnownTags;
import datadog.trace.api.intake.TrackType;
import datadog.trace.common.writer.PayloadDispatcher;
import datadog.trace.common.writer.RemoteApi;
import datadog.trace.common.writer.RemoteMapperDiscovery;
import datadog.trace.common.writer.RemoteWriter;
import datadog.trace.common.writer.TraceProcessingWorker;
import datadog.trace.common.writer.ddagent.Prioritization;
import datadog.trace.common.writer.ddintake.DDIntakeApi;
import datadog.trace.common.writer.ddintake.DDIntakeMapperDiscovery;
import datadog.trace.core.monitor.HealthMetrics;
import java.util.concurrent.TimeUnit;

public class DDIntakeWriter
extends RemoteWriter {
    public static final String DEFAULT_INTAKE_VERSION = "v2";
    public static final long DEFAULT_INTAKE_TIMEOUT = 10L;
    private static final int BUFFER_SIZE = 1024;

    public static DDIntakeWriterBuilder builder() {
        return new DDIntakeWriterBuilder();
    }

    private DDIntakeWriter(RemoteApi api, HealthMetrics healthMetrics, Monitoring monitoring, TraceProcessingWorker worker, RemoteMapperDiscovery discovery) {
        this(api, healthMetrics, new PayloadDispatcher(discovery, api, healthMetrics, monitoring), worker, true);
    }

    protected DDIntakeWriter(RemoteApi api, HealthMetrics healthMetrics, PayloadDispatcher dispatcher, TraceProcessingWorker traceProcessingWorker, boolean alwaysFlush) {
        super(api, traceProcessingWorker, dispatcher, healthMetrics, alwaysFlush);
    }

    protected DDIntakeWriter(RemoteApi api, HealthMetrics healthMetrics, PayloadDispatcher dispatcher, TraceProcessingWorker traceProcessingWorker, int flushTimeout, TimeUnit flushTimeoutUnit, boolean alwaysFlush) {
        super(api, traceProcessingWorker, dispatcher, healthMetrics, flushTimeout, flushTimeoutUnit, alwaysFlush);
    }

    public static class DDIntakeWriterBuilder {
        String site = Config.get().getSite();
        WellKnownTags wellKnownTags = Config.get().getWellKnownTags();
        TrackType trackType = TrackType.NOOP;
        String apiVersion = "v2";
        long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        int traceBufferSize = 1024;
        HealthMetrics healthMetrics = new HealthMetrics(StatsDClient.NO_OP);
        int flushFrequencySeconds = 1;
        Monitoring monitoring = Monitoring.DISABLED;
        DroppingPolicy droppingPolicy = DroppingPolicy.DISABLED;
        Prioritization prioritization = Prioritization.FAST_LANE;
        RetryPolicy retryPolicy = RetryPolicy.builder().withMaxRetry(5).withBackoff(100L).build();
        private int flushTimeout = 5;
        private TimeUnit flushTimeoutUnit = TimeUnit.SECONDS;
        private boolean alwaysFlush = true;
        private DDIntakeApi intakeApi;
        private String apiKey;

        public DDIntakeWriterBuilder intakeApi(DDIntakeApi intakeApi) {
            this.intakeApi = intakeApi;
            return this;
        }

        public DDIntakeWriterBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public DDIntakeWriterBuilder site(String site) {
            this.site = site;
            return this;
        }

        public DDIntakeWriterBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDIntakeWriterBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDIntakeWriterBuilder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public DDIntakeWriterBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDIntakeWriterBuilder traceBufferSize(int traceBufferSize) {
            this.traceBufferSize = traceBufferSize;
            return this;
        }

        public DDIntakeWriterBuilder healthMetrics(HealthMetrics healthMetrics) {
            this.healthMetrics = healthMetrics;
            return this;
        }

        public DDIntakeWriterBuilder flushFrequencySeconds(int flushFrequencySeconds) {
            this.flushFrequencySeconds = flushFrequencySeconds;
            return this;
        }

        public DDIntakeWriterBuilder prioritization(Prioritization prioritization) {
            this.prioritization = prioritization;
            return this;
        }

        public DDIntakeWriterBuilder droppingPolicy(DroppingPolicy droppingPolicy) {
            this.droppingPolicy = droppingPolicy;
            return this;
        }

        public DDIntakeWriterBuilder wellKnownTags(WellKnownTags wellKnownTags) {
            this.wellKnownTags = wellKnownTags;
            return this;
        }

        public DDIntakeWriterBuilder alwaysFlush(boolean alwaysFlush) {
            this.alwaysFlush = alwaysFlush;
            return this;
        }

        public DDIntakeWriterBuilder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public DDIntakeWriterBuilder flushTimeout(int flushTimeout, TimeUnit flushTimeoutUnit) {
            this.flushTimeout = flushTimeout;
            this.flushTimeoutUnit = flushTimeoutUnit;
            return this;
        }

        public DDIntakeWriter build() {
            if (null == this.intakeApi) {
                this.intakeApi = DDIntakeApi.builder().site(this.site).trackType(this.trackType).apiVersion(this.apiVersion).apiKey(this.apiKey).timeoutMillis(this.timeoutMillis).retryPolicy(this.retryPolicy).build();
            }
            DDIntakeMapperDiscovery mapperDiscovery = new DDIntakeMapperDiscovery(this.trackType, this.wellKnownTags);
            PayloadDispatcher dispatcher = new PayloadDispatcher(mapperDiscovery, this.intakeApi, this.healthMetrics, this.monitoring);
            TraceProcessingWorker traceProcessingWorker = new TraceProcessingWorker(this.traceBufferSize, this.healthMetrics, dispatcher, this.droppingPolicy, this.prioritization, this.flushFrequencySeconds, TimeUnit.SECONDS);
            return new DDIntakeWriter((RemoteApi)this.intakeApi, this.healthMetrics, dispatcher, traceProcessingWorker, this.flushTimeout, this.flushTimeoutUnit, this.alwaysFlush);
        }
    }
}

