/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.datastreams;

import com.datadoghq.sketch.ddsketch.encoding.ByteArrayInput;
import com.datadoghq.sketch.ddsketch.encoding.GrowingByteArrayOutput;
import com.datadoghq.sketch.ddsketch.encoding.Input;
import com.datadoghq.sketch.ddsketch.encoding.Output;
import com.datadoghq.sketch.ddsketch.encoding.VarEncodingHelper;
import datadog.trace.api.Config;
import datadog.trace.api.WellKnownTags;
import datadog.trace.api.function.Consumer;
import datadog.trace.api.time.TimeSource;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import datadog.trace.bootstrap.instrumentation.api.StatsPoint;
import datadog.trace.util.FNV64Hash;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPathwayContext
implements PathwayContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultPathwayContext.class);
    private static final String INITIALIZATION_TOPIC = "";
    private final Lock lock = new ReentrantLock();
    private final WellKnownTags wellKnownTags;
    private final TimeSource timeSource;
    private final GrowingByteArrayOutput outputBuffer = GrowingByteArrayOutput.withInitialCapacity((int)20);
    private long pathwayStartNanos;
    private long pathwayStartNanoTicks;
    private long edgeStartNanoTicks;
    private long hash;
    private boolean started;

    public DefaultPathwayContext(TimeSource timeSource, WellKnownTags wellKnownTags) {
        this.timeSource = timeSource;
        this.wellKnownTags = wellKnownTags;
    }

    private DefaultPathwayContext(TimeSource timeSource, WellKnownTags wellKnownTags, long pathwayStartNanos, long pathwayStartNanoTicks, long edgeStartNanoTicks, long hash) {
        this.timeSource = timeSource;
        this.wellKnownTags = wellKnownTags;
        this.pathwayStartNanos = pathwayStartNanos;
        this.pathwayStartNanoTicks = pathwayStartNanoTicks;
        this.edgeStartNanoTicks = edgeStartNanoTicks;
        this.hash = hash;
        this.started = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(Consumer<StatsPoint> pointConsumer) {
        this.setCheckpoint(null, null, INITIALIZATION_TOPIC, pointConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpoint(String type, String group, String topic, Consumer<StatsPoint> pointConsumer) {
        long startNanos = this.timeSource.getCurrentTimeNanos();
        long nanoTicks = this.timeSource.getNanoTicks();
        this.lock.lock();
        try {
            if (INITIALIZATION_TOPIC.equals(topic) && this.started) {
                return;
            }
            ArrayList<String> edgeTags = new ArrayList<String>();
            if (this.started) {
                if (type != null && !type.isEmpty()) {
                    edgeTags.add("type:" + type);
                }
                if (topic != null && !topic.isEmpty()) {
                    edgeTags.add("topic:" + topic);
                }
                if (group != null && !group.isEmpty()) {
                    edgeTags.add("group:" + group);
                }
            } else {
                this.pathwayStartNanos = startNanos;
                this.pathwayStartNanoTicks = nanoTicks;
                this.edgeStartNanoTicks = nanoTicks;
                this.hash = 0L;
                this.started = true;
                log.debug("Started {}", (Object)this);
            }
            long newHash = this.generatePathwayHash(edgeTags, this.hash);
            long pathwayLatencyNano = nanoTicks - this.pathwayStartNanoTicks;
            long edgeLatencyNano = nanoTicks - this.edgeStartNanoTicks;
            StatsPoint point = new StatsPoint(edgeTags, newHash, this.hash, this.timeSource.getCurrentTimeNanos(), pathwayLatencyNano, edgeLatencyNano);
            this.edgeStartNanoTicks = nanoTicks;
            this.hash = newHash;
            pointConsumer.accept(point);
            log.debug("Checkpoint set {}", (Object)this);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode() throws IOException {
        this.lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Context must be started to encode");
            }
            this.outputBuffer.clear();
            this.outputBuffer.writeLongLE(this.hash);
            long pathwayStartMillis = TimeUnit.NANOSECONDS.toMillis(this.pathwayStartNanos);
            VarEncodingHelper.encodeSignedVarLong((Output)this.outputBuffer, (long)pathwayStartMillis);
            long edgeStartMillis = pathwayStartMillis + TimeUnit.NANOSECONDS.toMillis(this.edgeStartNanoTicks - this.pathwayStartNanoTicks);
            VarEncodingHelper.encodeSignedVarLong((Output)this.outputBuffer, (long)edgeStartMillis);
            byte[] byArray = this.outputBuffer.trimmedCopy();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            if (this.started) {
                String string = "PathwayContext[ Hash " + DefaultPathwayContext.toUnsignedString(this.hash) + ", Start: " + this.pathwayStartNanos + ", StartTicks: " + this.pathwayStartNanoTicks + ", Edge Start Ticks: " + this.edgeStartNanoTicks + ", objectHashcode:" + this.hashCode() + "]";
                return string;
            }
            String string = "PathwayContext [Not Started]";
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        long quot = (l >>> 1) / 5L;
        long rem = l - quot * 10L;
        return Long.toString(quot) + rem;
    }

    public static <C> DefaultPathwayContext extract(C carrier, AgentPropagation.BinaryContextVisitor<C> getter, TimeSource timeSource, WellKnownTags wellKnownTags) {
        PathwayContextExtractor pathwayContextExtractor = new PathwayContextExtractor(timeSource, wellKnownTags);
        getter.forEachKey(carrier, pathwayContextExtractor);
        if (pathwayContextExtractor.extractedContext == null) {
            log.debug("No context extracted");
        } else {
            log.debug("Extracted context: {} ", (Object)pathwayContextExtractor.extractedContext);
        }
        return pathwayContextExtractor.extractedContext;
    }

    public static DefaultPathwayContext decode(TimeSource timeSource, WellKnownTags wellKnownTags, byte[] data) throws IOException {
        ByteArrayInput input = ByteArrayInput.wrap((byte[])data);
        long hash = input.readLongLE();
        long pathwayStartMillis = VarEncodingHelper.decodeSignedVarLong((Input)input);
        long pathwayStartNanos = TimeUnit.MILLISECONDS.toNanos(pathwayStartMillis);
        long nowNanos = timeSource.getCurrentTimeNanos();
        long nanosSinceStart = nowNanos - pathwayStartNanos;
        long nowNanoTicks = timeSource.getNanoTicks();
        long pathwayStartNanoTicks = nowNanoTicks - nanosSinceStart;
        long edgeStartMillis = VarEncodingHelper.decodeSignedVarLong((Input)input);
        long edgeStartNanoTicks = pathwayStartNanoTicks + TimeUnit.MILLISECONDS.toNanos(edgeStartMillis - pathwayStartMillis);
        return new DefaultPathwayContext(timeSource, wellKnownTags, pathwayStartNanos, pathwayStartNanoTicks, edgeStartNanoTicks, hash);
    }

    private long generateNodeHash(List<String> edgeTags) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.wellKnownTags.getService());
        builder.append(this.wellKnownTags.getEnv());
        String primaryTag = Config.get().getPrimaryTag();
        if (primaryTag != null) {
            builder.append(primaryTag);
        }
        for (String tag : edgeTags) {
            builder.append(tag);
        }
        return FNV64Hash.generateHash(builder.toString(), FNV64Hash.Version.v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generatePathwayHash(List<String> edgeTags, long parentHash) {
        long nodeHash = this.generateNodeHash(edgeTags);
        this.lock.lock();
        try {
            this.outputBuffer.clear();
            this.outputBuffer.writeLongLE(nodeHash);
            this.outputBuffer.writeLongLE(parentHash);
            long l = FNV64Hash.generateHash(this.outputBuffer.backingArray(), 0, 16, FNV64Hash.Version.v1);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PathwayContextExtractor
    implements AgentPropagation.BinaryKeyClassifier {
        private final TimeSource timeSource;
        private final WellKnownTags wellKnownTags;
        private DefaultPathwayContext extractedContext;

        PathwayContextExtractor(TimeSource timeSource, WellKnownTags wellKnownTags) {
            this.timeSource = timeSource;
            this.wellKnownTags = wellKnownTags;
        }

        @Override
        public boolean accept(String key, byte[] value) {
            if ("dd-pathway-ctx".equalsIgnoreCase(key)) {
                try {
                    this.extractedContext = DefaultPathwayContext.decode(this.timeSource, this.wellKnownTags, value);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }
    }
}

