/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.lambda;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import datadog.trace.core.propagation.LambdaContext;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaHandler {
    private static final Logger log = LoggerFactory.getLogger(LambdaHandler.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_TRACE_ID = "x-datadog-trace-id";
    private static final String DATADOG_SPAN_ID = "x-datadog-span-id";
    private static final String DATADOG_SAMPLING_PRIORITY = "x-datadog-sampling-priority";
    private static final String DATADOG_INVOCATION_ERROR = "x-datadog-invocation-error";
    private static final String START_INVOCATION = "/lambda/start-invocation";
    private static final String END_INVOCATION = "/lambda/end-invocation";
    private static final Long REQUEST_TIMEOUT_IN_S = 1L;
    private static OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(REQUEST_TIMEOUT_IN_S.longValue(), TimeUnit.SECONDS).writeTimeout(REQUEST_TIMEOUT_IN_S.longValue(), TimeUnit.SECONDS).readTimeout(REQUEST_TIMEOUT_IN_S.longValue(), TimeUnit.SECONDS).callTimeout(REQUEST_TIMEOUT_IN_S.longValue(), TimeUnit.SECONDS).build();
    private static final MediaType jsonMediaType = MediaType.parse((String)"application/json");
    private static final JsonAdapter<Object> adapter = new Moshi.Builder().build().adapter(Object.class);
    private static String EXTENSION_BASE_URL = "http://127.0.0.1:8124";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LambdaContext notifyStartInvocation(Object event) {
        RequestBody body = RequestBody.create((MediaType)jsonMediaType, (String)LambdaHandler.writeValueAsString(event));
        try (Response response = HTTP_CLIENT.newCall(new Request.Builder().url(EXTENSION_BASE_URL + START_INVOCATION).addHeader(DATADOG_META_LANG, "java").post(body).build()).execute();){
            if (!response.isSuccessful()) return null;
            String traceID = response.headers().get(DATADOG_TRACE_ID);
            String spanID = response.headers().get(DATADOG_SPAN_ID);
            String priority = response.headers().get(DATADOG_SAMPLING_PRIORITY);
            if (null != traceID && null != spanID) {
                log.debug("notifyStartInvocation success, found traceID = {} and spanID = {}", (Object)traceID, (Object)spanID);
                int samplingPriority = -128;
                try {
                    samplingPriority = Integer.parseInt(priority);
                }
                catch (NumberFormatException ignored) {
                    log.warn("could not read the sampling priority, defaulting to UNSET");
                }
                LambdaContext lambdaContext = new LambdaContext(traceID, spanID, samplingPriority);
                return lambdaContext;
            }
            log.error("could not find traceID/spanID in notifyStartInvocation, not injecting the context");
            return null;
        }
        catch (Throwable ignored) {
            log.error("could not reach the extension");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean notifyEndInvocation(boolean isError) {
        RequestBody body = RequestBody.create((MediaType)jsonMediaType, (String)"{}");
        Request.Builder builder = new Request.Builder().url(EXTENSION_BASE_URL + END_INVOCATION).addHeader(DATADOG_META_LANG, "java").post(body);
        if (isError) {
            builder.addHeader(DATADOG_INVOCATION_ERROR, "true");
        }
        try (Response response = HTTP_CLIENT.newCall(builder.build()).execute();){
            if (!response.isSuccessful()) return false;
            log.debug("notifyEndInvocation success");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("could not reach the extension, not injecting the context", (Throwable)e);
        }
        return false;
    }

    public static String writeValueAsString(Object obj) {
        String json = "{}";
        if (null != obj) {
            try {
                json = adapter.toJson(obj);
            }
            catch (Exception e) {
                log.error("could not write the value into a string", (Throwable)e);
            }
        }
        return json;
    }

    public static void setExtensionBaseUrl(String extensionBaseUrl) {
        EXTENSION_BASE_URL = extensionBaseUrl;
    }
}

