/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.util;

import datadog.trace.api.time.SystemTimeSource;
import datadog.trace.api.time.TimeSource;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleRateLimiter {
    private final TimeSource timeSource;
    private final int capacity;
    private final long startNanos;
    private final AtomicLong secondsAndCount;

    public SimpleRateLimiter(int rate) {
        this(rate, SystemTimeSource.INSTANCE);
    }

    protected SimpleRateLimiter(int rate, TimeSource timeSource) {
        this.timeSource = timeSource;
        this.startNanos = timeSource.getNanoTicks();
        this.capacity = Math.max(1, rate);
        this.secondsAndCount = new AtomicLong(0L);
    }

    public boolean tryAcquire() {
        long newSecondsAndCount;
        long storedSecondsAndCount;
        int seconds = 0;
        boolean readTime = true;
        do {
            storedSecondsAndCount = this.secondsAndCount.get();
            if (readTime) {
                seconds = (int)TimeUnit.NANOSECONDS.toSeconds(this.timeSource.getNanoTicks() - this.startNanos);
                readTime = false;
            }
            int storedSeconds = SimpleRateLimiter.getStoredSeconds(storedSecondsAndCount);
            int storedCount = SimpleRateLimiter.getStoredCount(storedSecondsAndCount);
            int diff = seconds - storedSeconds;
            if (diff <= 0) {
                int count = storedCount + 1;
                if (count > this.capacity || count < 0) {
                    return false;
                }
                newSecondsAndCount = SimpleRateLimiter.combineSecondsAndCount(storedSeconds, count);
                if (diff >= 0) continue;
                readTime = true;
                continue;
            }
            newSecondsAndCount = SimpleRateLimiter.combineSecondsAndCount(seconds, 1);
        } while (!this.secondsAndCount.compareAndSet(storedSecondsAndCount, newSecondsAndCount));
        return true;
    }

    private static int getStoredSeconds(long timeAndCount) {
        return (int)(timeAndCount >> 32);
    }

    private static int getStoredCount(long timeAndCount) {
        return (int)(timeAndCount & Integer.MAX_VALUE);
    }

    private static long combineSecondsAndCount(int seconds, int count) {
        return (long)(seconds & Integer.MAX_VALUE) << 32 | (long)count;
    }
}

