/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.http;

import datadog.trace.api.function.BiFunction;
import datadog.trace.api.function.Supplier;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.InstrumentationGateway;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.http.StoredBodySupplier;
import datadog.trace.api.http.StoredByteBody;
import datadog.trace.api.http.StoredCharBody;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.nio.charset.Charset;

public class StoredBodyFactories {
    private StoredBodyFactories() {
    }

    public static StoredByteBody maybeCreateForByte(Charset charset, Object contentLengthHeader) {
        AgentSpan agentSpan = AgentTracer.activeSpan();
        if (agentSpan == null) {
            return null;
        }
        return StoredBodyFactories.maybeCreateForByte(charset, agentSpan, contentLengthHeader);
    }

    public static StoredByteBody maybeCreateForByte(Charset charset, AgentSpan agentSpan, Object contentLengthHeader) {
        RequestContext<Object> requestContext = agentSpan.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        InstrumentationGateway cbp = AgentTracer.get().instrumentationGateway();
        BiFunction<RequestContext<Object>, StoredBodySupplier, Void> requestStartCb = cbp.getCallback(Events.EVENTS.requestBodyStart());
        BiFunction<RequestContext<Object>, StoredBodySupplier, Flow<Void>> requestEndedCb = cbp.getCallback(Events.EVENTS.requestBodyDone());
        if (requestStartCb == null || requestEndedCb == null) {
            return null;
        }
        int lengthHint = StoredBodyFactories.parseLengthHeader(contentLengthHeader);
        return new StoredByteBody(requestContext, requestStartCb, requestEndedCb, charset, lengthHint);
    }

    public static Flow<Void> maybeDeliverBodyInOneGo(Supplier<CharSequence> supplier) {
        AgentSpan agentSpan = AgentTracer.activeSpan();
        if (agentSpan == null) {
            return Flow.ResultFlow.empty();
        }
        RequestContext<Object> requestContext = agentSpan.getRequestContext();
        if (requestContext == null) {
            return Flow.ResultFlow.empty();
        }
        InstrumentationGateway cbp = AgentTracer.get().instrumentationGateway();
        BiFunction<RequestContext<Object>, StoredBodySupplier, Void> requestStartCb = cbp.getCallback(Events.EVENTS.requestBodyStart());
        BiFunction<RequestContext<Object>, StoredBodySupplier, Flow<Void>> requestEndedCb = cbp.getCallback(Events.EVENTS.requestBodyDone());
        if (requestStartCb == null || requestEndedCb == null) {
            return Flow.ResultFlow.empty();
        }
        ConstantBodySupplier wrappedSupplier = new ConstantBodySupplier(supplier);
        requestStartCb.apply(requestContext, wrappedSupplier);
        return requestEndedCb.apply(requestContext, wrappedSupplier);
    }

    public static Flow<Void> maybeDeliverBodyInOneGo(final String str) {
        return StoredBodyFactories.maybeDeliverBodyInOneGo(new Supplier<CharSequence>(){

            @Override
            public CharSequence get() {
                return str;
            }
        });
    }

    public static StoredCharBody maybeCreateForChar(Object contentLengthHeader) {
        AgentSpan agentSpan = AgentTracer.activeSpan();
        if (agentSpan == null) {
            return null;
        }
        return StoredBodyFactories.maybeCreateForChar(agentSpan, contentLengthHeader);
    }

    public static StoredCharBody maybeCreateForChar(AgentSpan agentSpan, Object contentLengthHeader) {
        RequestContext<Object> requestContext = agentSpan.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        InstrumentationGateway cbp = AgentTracer.get().instrumentationGateway();
        BiFunction<RequestContext<Object>, StoredBodySupplier, Void> requestStartCb = cbp.getCallback(Events.EVENTS.requestBodyStart());
        BiFunction<RequestContext<Object>, StoredBodySupplier, Flow<Void>> requestEndedCb = cbp.getCallback(Events.EVENTS.requestBodyDone());
        if (requestStartCb == null || requestEndedCb == null) {
            return null;
        }
        int lengthHint = StoredBodyFactories.parseLengthHeader(contentLengthHeader);
        return new StoredCharBody(requestContext, requestStartCb, requestEndedCb, lengthHint);
    }

    private static int parseLengthHeader(Object contentLengthHeader) {
        if (contentLengthHeader instanceof Number) {
            return ((Number)contentLengthHeader).intValue();
        }
        if (contentLengthHeader != null) {
            try {
                return Integer.parseInt(contentLengthHeader.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static class ConstantBodySupplier
    implements StoredBodySupplier {
        private final CharSequence sequence;

        public ConstantBodySupplier(Supplier<CharSequence> original) {
            this.sequence = original.get();
        }

        @Override
        public CharSequence get() {
            return this.sequence;
        }
    }
}

