/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddintake;

import datadog.communication.http.OkHttpUtils;
import datadog.communication.http.RetryPolicy;
import datadog.trace.api.Config;
import datadog.trace.api.intake.TrackType;
import datadog.trace.common.writer.Payload;
import datadog.trace.common.writer.RemoteApi;
import datadog.trace.common.writer.RemoteResponseListener;
import datadog.trace.relocate.api.IOLogger;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDIntakeApi
implements RemoteApi {
    private static final String DD_API_KEY_HEADER = "dd-api-key";
    private static final Logger log = LoggerFactory.getLogger(DDIntakeApi.class);
    private final IOLogger ioLogger = new IOLogger(log);
    private long totalTraces = 0L;
    private long receivedTraces = 0L;
    private long sentTraces = 0L;
    private long failedTraces = 0L;
    private final OkHttpClient httpClient;
    private final HttpUrl intakeUrl;
    private final String apiKey;
    private final RetryPolicy retryPolicy;

    public static DDIntakeApiBuilder builder() {
        return new DDIntakeApiBuilder();
    }

    private DDIntakeApi(OkHttpClient httpClient, HttpUrl intakeUrl, String apiKey, RetryPolicy retryPolicy) {
        this.httpClient = httpClient;
        this.intakeUrl = intakeUrl;
        this.apiKey = apiKey;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        int sizeInBytes = payload.sizeInBytes();
        int retry = 1;
        try {
            Request request = new Request.Builder().url(this.intakeUrl).addHeader(DD_API_KEY_HEADER, this.apiKey).post(payload.toRequest()).build();
            this.totalTraces += (long)payload.traceCount();
            this.receivedTraces += (long)payload.traceCount();
            int httpCode = 0;
            ConnectException lastException = null;
            Response lastResponse = null;
            while (true) {
                boolean shouldRetry;
                try (okhttp3.Response response = this.httpClient.newCall(request).execute();){
                    httpCode = response.code();
                    boolean bl = shouldRetry = httpCode >= 500 && this.retryPolicy.shouldRetry(retry);
                    if (!shouldRetry && httpCode >= 400) {
                        lastResponse = new Response(httpCode, response.message(), DDIntakeApi.getResponseBody(response));
                    }
                }
                catch (ConnectException ex) {
                    shouldRetry = this.retryPolicy.shouldRetry(retry);
                    lastException = ex;
                }
                if (!shouldRetry) break;
                long backoffMs = this.retryPolicy.backoff(retry);
                try {
                    Thread.sleep(backoffMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                ++retry;
            }
            if (httpCode < 200 || httpCode >= 300) {
                this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, lastResponse, null);
                return RemoteApi.Response.failed(httpCode);
            }
            if (lastException != null) {
                throw lastException;
            }
            this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
            return RemoteApi.Response.success(httpCode);
        }
        catch (IOException e) {
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
    }

    private void countAndLogSuccessfulSend(int traceCount, int sizeInBytes) {
        this.sentTraces += (long)traceCount;
        this.ioLogger.success(this.createSendLogMessage(traceCount, sizeInBytes, "Success"), new Object[0]);
    }

    private void countAndLogFailedSend(int traceCount, int sizeInBytes, Response response, IOException outer) {
        this.failedTraces += (long)traceCount;
        String intakeError = response != null ? response.body : "";
        String sendErrorString = this.createSendLogMessage(traceCount, sizeInBytes, intakeError.isEmpty() ? "Error" : intakeError);
        this.ioLogger.error(sendErrorString, DDIntakeApi.toLoggerResponse(response), outer);
    }

    private static IOLogger.Response toLoggerResponse(Response response) {
        if (response == null) {
            return null;
        }
        return new IOLogger.Response(response.code, response.message, response.body);
    }

    private static String getResponseBody(okhttp3.Response response) {
        if (response != null) {
            try {
                return response.body().string().trim();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        }
        return "";
    }

    private String createSendLogMessage(int traceCount, int sizeInBytes, String prefix) {
        String sizeString = sizeInBytes > 1024 ? sizeInBytes / 1024 + "KB" : sizeInBytes + "B";
        return prefix + " while sending " + traceCount + " (size=" + sizeString + ") traces to the DD Intake. Total: " + this.totalTraces + ", Received: " + this.receivedTraces + ", Sent: " + this.sentTraces + ", Failed: " + this.failedTraces + ".";
    }

    @Override
    public void addResponseListener(RemoteResponseListener listener) {
    }

    private static class Response {
        private final int code;
        private final String message;
        private final String body;

        public Response(int code, String message, String body) {
            this.code = code;
            this.message = message;
            this.body = body;
        }
    }

    public static class DDIntakeApiBuilder {
        private String site = Config.get().getSite();
        private String apiVersion = "v2";
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl hostUrl = null;
        OkHttpClient httpClient = null;
        RetryPolicy retryPolicy = null;
        private String apiKey;

        public DDIntakeApiBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDIntakeApiBuilder site(String site) {
            this.site = site;
            return this;
        }

        public DDIntakeApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDIntakeApiBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public DDIntakeApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDIntakeApiBuilder hostUrl(HttpUrl hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public DDIntakeApiBuilder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        DDIntakeApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDIntakeApi build() {
            OkHttpClient client;
            assert (this.apiKey != null);
            String trackName = (this.trackType != null ? this.trackType.name() : TrackType.NOOP.name()).toLowerCase();
            if (null == this.hostUrl) {
                this.hostUrl = HttpUrl.get((String)String.format("https://%s-intake.%s", trackName, this.site));
            }
            HttpUrl intakeUrl = this.hostUrl.resolve(String.format("/api/%s/%s", this.apiVersion, trackName));
            OkHttpClient okHttpClient = client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(intakeUrl, this.timeoutMillis);
            if (null == this.retryPolicy) {
                this.retryPolicy = RetryPolicy.builder().withMaxRetry(5).withBackoff(100L).build();
            }
            return new DDIntakeApi(client, intakeUrl, this.apiKey, this.retryPolicy);
        }
    }
}

