/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.metrics;

import datadog.communication.serialization.GrowableBuffer;
import datadog.communication.serialization.WritableFormatter;
import datadog.communication.serialization.msgpack.MsgPackWriter;
import datadog.trace.api.WellKnownTags;
import datadog.trace.common.metrics.AggregateMetric;
import datadog.trace.common.metrics.MetricKey;
import datadog.trace.common.metrics.MetricWriter;
import datadog.trace.common.metrics.Sink;
import java.nio.charset.StandardCharsets;

public final class SerializingMetricWriter
implements MetricWriter {
    private static final byte[] SEQUENCE = "Seq".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] RUNTIME_ID = "RuntimeId".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HOSTNAME = "Hostname".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] NAME = "Name".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ENV = "Env".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SERVICE = "Service".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] RESOURCE = "Resource".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] VERSION = "Version".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HITS = "Hits".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ERRORS = "Errors".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TOP_LEVEL_HITS = "TopLevelHits".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] DURATION = "Duration".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TYPE = "Type".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HTTP_STATUS_CODE = "HTTPStatusCode".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] START = "Start".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] STATS = "Stats".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] OK_SUMMARY = "OkSummary".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ERROR_SUMMARY = "ErrorSummary".getBytes(StandardCharsets.ISO_8859_1);
    private final WellKnownTags wellKnownTags;
    private final WritableFormatter writer;
    private final Sink sink;
    private final GrowableBuffer buffer;
    private long sequence = 0L;

    public SerializingMetricWriter(WellKnownTags wellKnownTags, Sink sink) {
        this(wellKnownTags, sink, 524288);
    }

    public SerializingMetricWriter(WellKnownTags wellKnownTags, Sink sink, int initialCapacity) {
        this.wellKnownTags = wellKnownTags;
        this.buffer = new GrowableBuffer(initialCapacity);
        this.writer = new MsgPackWriter(this.buffer);
        this.sink = sink;
    }

    @Override
    public void startBucket(int metricCount, long start, long duration) {
        this.writer.startMap(6);
        this.writer.writeUTF8(RUNTIME_ID);
        this.writer.writeUTF8(this.wellKnownTags.getRuntimeId());
        this.writer.writeUTF8(SEQUENCE);
        this.writer.writeLong(this.sequence++);
        this.writer.writeUTF8(HOSTNAME);
        this.writer.writeUTF8(this.wellKnownTags.getHostname());
        this.writer.writeUTF8(ENV);
        this.writer.writeUTF8(this.wellKnownTags.getEnv());
        this.writer.writeUTF8(VERSION);
        this.writer.writeUTF8(this.wellKnownTags.getVersion());
        this.writer.writeUTF8(STATS);
        this.writer.startArray(1);
        this.writer.startMap(3);
        this.writer.writeUTF8(START);
        this.writer.writeLong(start);
        this.writer.writeUTF8(DURATION);
        this.writer.writeLong(duration);
        this.writer.writeUTF8(STATS);
        this.writer.startArray(metricCount);
    }

    @Override
    public void add(MetricKey key, AggregateMetric aggregate) {
        this.writer.startMap(11);
        this.writer.writeUTF8(NAME);
        this.writer.writeUTF8(key.getOperationName());
        this.writer.writeUTF8(SERVICE);
        this.writer.writeUTF8(key.getService());
        this.writer.writeUTF8(RESOURCE);
        this.writer.writeUTF8(key.getResource());
        this.writer.writeUTF8(TYPE);
        this.writer.writeUTF8(key.getType());
        this.writer.writeUTF8(HTTP_STATUS_CODE);
        this.writer.writeInt(key.getHttpStatusCode());
        this.writer.writeUTF8(HITS);
        this.writer.writeInt(aggregate.getHitCount());
        this.writer.writeUTF8(ERRORS);
        this.writer.writeInt(aggregate.getErrorCount());
        this.writer.writeUTF8(TOP_LEVEL_HITS);
        this.writer.writeInt(aggregate.getTopLevelCount());
        this.writer.writeUTF8(DURATION);
        this.writer.writeLong(aggregate.getDuration());
        this.writer.writeUTF8(OK_SUMMARY);
        this.writer.writeBinary(aggregate.getOkLatencies().serialize());
        this.writer.writeUTF8(ERROR_SUMMARY);
        this.writer.writeBinary(aggregate.getErrorLatencies().serialize());
    }

    @Override
    public void finishBucket() {
        this.buffer.mark();
        this.sink.accept(this.buffer.messageCount(), this.buffer.slice());
        this.buffer.reset();
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }
}

