/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.profiling;

import datadog.trace.api.profiling.TracingContextTracker;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TracingContextTrackerFactory {
    private static final Logger log = LoggerFactory.getLogger(TracingContextTrackerFactory.class);
    private static final TracingContextTrackerFactory INSTANCE = new TracingContextTrackerFactory();
    private volatile Implementation implementation = Implementation.EMPTY;
    private final AtomicReferenceFieldUpdater<TracingContextTrackerFactory, Implementation> implFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(TracingContextTrackerFactory.class, Implementation.class, "implementation");

    public static boolean registerImplementation(Implementation factoryImplementation) {
        try {
            return TracingContextTrackerFactory.INSTANCE.implFieldUpdater.compareAndSet(INSTANCE, Implementation.EMPTY, factoryImplementation);
        }
        catch (Throwable t) {
            log.warn("Failed to register a profiling context implementation", t);
            return false;
        }
    }

    static void removeImplementation(Implementation implementation) {
        TracingContextTrackerFactory.INSTANCE.implFieldUpdater.compareAndSet(INSTANCE, implementation, Implementation.EMPTY);
    }

    public static boolean isTrackingAvailable() {
        return TracingContextTrackerFactory.INSTANCE.implementation != Implementation.EMPTY;
    }

    public static TracingContextTracker instance(AgentSpan span) {
        return TracingContextTrackerFactory.INSTANCE.implementation.instance(span);
    }

    public static interface Implementation {
        public static final Implementation EMPTY = new Implementation(){

            @Override
            public TracingContextTracker instance(AgentSpan span) {
                return TracingContextTracker.EMPTY;
            }
        };

        public TracingContextTracker instance(AgentSpan var1);
    }
}

