/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.common.writer.PayloadDispatcher;
import datadog.trace.common.writer.RemoteApi;
import datadog.trace.common.writer.RemoteResponseListener;
import datadog.trace.common.writer.TraceProcessingWorker;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.monitor.HealthMetrics;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(RemoteWriter.class);
    private final RemoteApi api;
    protected final TraceProcessingWorker traceProcessingWorker;
    private final PayloadDispatcher dispatcher;
    private final boolean alwaysFlush;
    private final int flushTimeout;
    private final TimeUnit flushTimeoutUnit;
    private volatile boolean closed;
    public final HealthMetrics healthMetrics;

    protected RemoteWriter(RemoteApi api, TraceProcessingWorker traceProcessingWorker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, int flushTimeout, TimeUnit flushTimeoutUnit, boolean alwaysFlush) {
        this.api = api;
        this.traceProcessingWorker = traceProcessingWorker;
        this.dispatcher = dispatcher;
        this.healthMetrics = healthMetrics;
        this.flushTimeout = flushTimeout;
        this.flushTimeoutUnit = flushTimeoutUnit;
        this.alwaysFlush = alwaysFlush;
    }

    protected RemoteWriter(RemoteApi api, TraceProcessingWorker traceProcessingWorker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, boolean alwaysFlush) {
        this(api, traceProcessingWorker, dispatcher, healthMetrics, 1, TimeUnit.SECONDS, alwaysFlush);
    }

    public void addResponseListener(RemoteResponseListener listener) {
        this.api.addResponseListener(listener);
    }

    public RemoteApi getApi() {
        return this.api;
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (!this.closed) {
            if (trace.isEmpty()) {
                this.handleDroppedTrace("Trace was empty", trace);
            } else {
                int samplingPriority;
                DDSpan root = trace.get(0);
                if (this.traceProcessingWorker.publish(root, samplingPriority = root.context().getSamplingPriority(), trace)) {
                    this.healthMetrics.onPublish(trace, samplingPriority);
                } else {
                    this.handleDroppedTrace("Trace written to overfilled buffer", trace, samplingPriority);
                }
            }
        } else {
            this.handleDroppedTrace("Trace written after shutdown.", trace);
        }
        if (this.alwaysFlush) {
            this.flush();
        }
    }

    private void handleDroppedTrace(String reason, List<DDSpan> trace) {
        log.debug("{}. Counted but dropping trace: {}", (Object)reason, trace);
        this.healthMetrics.onFailedPublish(-128);
        this.incrementDropCounts(trace.size());
    }

    private void handleDroppedTrace(String reason, List<DDSpan> trace, int samplingPriority) {
        log.debug("{}. Counted but dropping trace: {}", (Object)reason, trace);
        this.healthMetrics.onFailedPublish(samplingPriority);
        this.incrementDropCounts(trace.size());
    }

    public final long getCapacity() {
        return this.traceProcessingWorker.getCapacity();
    }

    @Override
    public boolean flush() {
        if (!this.closed && this.traceProcessingWorker.flush(this.flushTimeout, this.flushTimeoutUnit)) {
            this.healthMetrics.onFlush(false);
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        if (!this.closed) {
            this.traceProcessingWorker.start();
            this.healthMetrics.start();
            this.healthMetrics.onStart((int)this.getCapacity());
        }
    }

    @Override
    public void close() {
        boolean flushed = this.flush();
        this.closed = true;
        this.traceProcessingWorker.close();
        this.healthMetrics.close();
        this.healthMetrics.onShutdown(flushed);
    }

    @Override
    public void incrementDropCounts(int spanCount) {
        this.dispatcher.onDroppedTrace(spanCount);
    }
}

