/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.AppVeyorInfo;
import datadog.trace.bootstrap.instrumentation.ci.AzurePipelinesInfo;
import datadog.trace.bootstrap.instrumentation.ci.BitBucketInfo;
import datadog.trace.bootstrap.instrumentation.ci.BitriseInfo;
import datadog.trace.bootstrap.instrumentation.ci.BuildkiteInfo;
import datadog.trace.bootstrap.instrumentation.ci.CircleCIInfo;
import datadog.trace.bootstrap.instrumentation.ci.GitLabInfo;
import datadog.trace.bootstrap.instrumentation.ci.GithubActionsInfo;
import datadog.trace.bootstrap.instrumentation.ci.JenkinsInfo;
import datadog.trace.bootstrap.instrumentation.ci.TravisInfo;
import datadog.trace.bootstrap.instrumentation.ci.UnknownCIInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitUtils;
import datadog.trace.bootstrap.instrumentation.ci.git.LocalFSGitInfoExtractor;
import datadog.trace.bootstrap.instrumentation.ci.git.PersonInfo;
import datadog.trace.util.Strings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SuppressForbidden
public abstract class CIProviderInfo {
    protected Map<String, String> ciTags;

    public CIProviderInfo() {
        CIInfo ciInfo = this.buildCIInfo();
        GitInfo ciGitInfo = this.buildCIGitInfo();
        GitInfo localGitInfo = this.buildCILocalGitInfo(ciInfo);
        GitInfo userSuppliedGitInfo = this.buildCIUserSuppliedGitInfo();
        this.ciTags = new CITagsBuilder().withCiProviderName(ciInfo.getCiProviderName()).withCiPipelineId(ciInfo.getCiPipelineId()).withCiPipelineName(ciInfo.getCiPipelineName()).withCiStageName(ciInfo.getCiStageName()).withCiJobName(ciInfo.getCiJobName()).withCiPipelineNumber(ciInfo.getCiPipelineNumber()).withCiPipelineUrl(ciInfo.getCiPipelineUrl()).withCiJorUrl(ciInfo.getCiJobUrl()).withCiWorkspacePath(ciInfo.getCiWorkspace()).withCiEnvVars(ciInfo.getCiEnvVars()).withGitRepositoryUrl(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommit(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitBranch(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitTag(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitAuthorName(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitAuthorEmail(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitAuthorDate(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitCommitterName(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitCommitterEmail(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitCommitterDate(userSuppliedGitInfo, ciGitInfo, localGitInfo).withGitCommitMessage(userSuppliedGitInfo, ciGitInfo, localGitInfo).build();
    }

    protected abstract GitInfo buildCIGitInfo();

    protected abstract CIInfo buildCIInfo();

    protected String getGitFolderName() {
        return ".git";
    }

    private GitInfo buildCILocalGitInfo(CIInfo ciInfo) {
        if (ciInfo.getCiWorkspace() == null) {
            return GitInfo.NOOP;
        }
        return new LocalFSGitInfoExtractor().headCommit(Paths.get(ciInfo.getCiWorkspace(), this.getGitFolderName()).toFile().getAbsolutePath());
    }

    private GitInfo buildCIUserSuppliedGitInfo() {
        String gitRepositoryUrl = System.getenv("DD_GIT_REPOSITORY_URL");
        String gitTag = System.getenv("DD_GIT_TAG");
        String gitBranch = null;
        String rawGitBranchOrTag = System.getenv("DD_GIT_BRANCH");
        if (rawGitBranchOrTag != null) {
            if (!rawGitBranchOrTag.contains("tags")) {
                gitBranch = this.normalizeRef(rawGitBranchOrTag);
            } else if (gitTag == null) {
                gitTag = this.normalizeRef(rawGitBranchOrTag);
            }
        }
        String gitCommitSha = System.getenv("DD_GIT_COMMIT_SHA");
        String gitCommitMessage = System.getenv("DD_GIT_COMMIT_MESSAGE");
        String gitCommitAuthorName = System.getenv("DD_GIT_COMMIT_AUTHOR_NAME");
        String gitCommitAuthorEmail = System.getenv("DD_GIT_COMMIT_AUTHOR_EMAIL");
        String gitCommitAuthorDate = System.getenv("DD_GIT_COMMIT_AUTHOR_DATE");
        String gitCommitCommitterName = System.getenv("DD_GIT_COMMIT_COMMITTER_NAME");
        String gitCommitCommitterEmail = System.getenv("DD_GIT_COMMIT_COMMITTER_EMAIL");
        String gitCommitCommitterDate = System.getenv("DD_GIT_COMMIT_COMMITTER_DATE");
        return new GitInfo(gitRepositoryUrl, gitBranch, gitTag, new CommitInfo(gitCommitSha, new PersonInfo(gitCommitAuthorName, gitCommitAuthorEmail, gitCommitAuthorDate), new PersonInfo(gitCommitCommitterName, gitCommitCommitterEmail, gitCommitCommitterDate), gitCommitMessage));
    }

    public boolean isCI() {
        return true;
    }

    public Map<String, String> getCiTags() {
        return this.ciTags;
    }

    public static CIProviderInfo selectCI() {
        if (System.getenv("JENKINS_URL") != null) {
            return new JenkinsInfo();
        }
        if (System.getenv("GITLAB_CI") != null) {
            return new GitLabInfo();
        }
        if (System.getenv("TRAVIS") != null) {
            return new TravisInfo();
        }
        if (System.getenv("CIRCLECI") != null) {
            return new CircleCIInfo();
        }
        if (System.getenv("APPVEYOR") != null) {
            return new AppVeyorInfo();
        }
        if (System.getenv("TF_BUILD") != null) {
            return new AzurePipelinesInfo();
        }
        if (System.getenv("BITBUCKET_BUILD_NUMBER") != null) {
            return new BitBucketInfo();
        }
        if (System.getenv("GITHUB_ACTION") != null) {
            return new GithubActionsInfo();
        }
        if (System.getenv("BUILDKITE") != null) {
            return new BuildkiteInfo();
        }
        if (System.getenv("BITRISE_BUILD_SLUG") != null) {
            return new BitriseInfo();
        }
        return new UnknownCIInfo();
    }

    protected String expandTilde(String path) {
        if (path == null || path.isEmpty() || !path.startsWith("~")) {
            return path;
        }
        if (!path.equals("~") && !path.startsWith("~/")) {
            return path;
        }
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    protected String normalizeRef(String rawRef) {
        return GitUtils.normalizeRef(rawRef);
    }

    protected String filterSensitiveInfo(String urlStr) {
        return GitUtils.filterSensitiveInfo(urlStr);
    }

    public static class CIInfo {
        public static final CIInfo NOOP = new CIInfo();
        private final String ciProviderName;
        private final String ciPipelineId;
        private final String ciPipelineName;
        private final String ciStageName;
        private final String ciJobName;
        private final String ciPipelineNumber;
        private final String ciPipelineUrl;
        private final String ciJobUrl;
        private final String ciWorkspace;
        private final Map<String, String> ciEnvVars;

        public static Builder builder() {
            return new Builder();
        }

        public CIInfo() {
            this(null, null, null, null, null, null, null, null, null, null);
        }

        public CIInfo(String ciProviderName, String ciPipelineId, String ciPipelineName, String ciStageName, String ciJobName, String ciPipelineNumber, String ciPipelineUrl, String ciJobUrl, String ciWorkspace, Map<String, String> ciEnvVars) {
            this.ciProviderName = ciProviderName;
            this.ciPipelineId = ciPipelineId;
            this.ciPipelineName = ciPipelineName;
            this.ciStageName = ciStageName;
            this.ciJobName = ciJobName;
            this.ciPipelineNumber = ciPipelineNumber;
            this.ciPipelineUrl = ciPipelineUrl;
            this.ciJobUrl = ciJobUrl;
            this.ciWorkspace = ciWorkspace;
            this.ciEnvVars = ciEnvVars;
        }

        public String getCiProviderName() {
            return this.ciProviderName;
        }

        public String getCiPipelineId() {
            return this.ciPipelineId;
        }

        public String getCiPipelineName() {
            return this.ciPipelineName;
        }

        public String getCiStageName() {
            return this.ciStageName;
        }

        public String getCiJobName() {
            return this.ciJobName;
        }

        public String getCiPipelineNumber() {
            return this.ciPipelineNumber;
        }

        public String getCiPipelineUrl() {
            return this.ciPipelineUrl;
        }

        public String getCiJobUrl() {
            return this.ciJobUrl;
        }

        public String getCiWorkspace() {
            return this.ciWorkspace;
        }

        public Map<String, String> getCiEnvVars() {
            return this.ciEnvVars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CIInfo ciInfo = (CIInfo)o;
            return Objects.equals(this.ciProviderName, ciInfo.ciProviderName) && Objects.equals(this.ciPipelineId, ciInfo.ciPipelineId) && Objects.equals(this.ciPipelineName, ciInfo.ciPipelineName) && Objects.equals(this.ciStageName, ciInfo.ciStageName) && Objects.equals(this.ciJobName, ciInfo.ciJobName) && Objects.equals(this.ciPipelineNumber, ciInfo.ciPipelineNumber) && Objects.equals(this.ciPipelineUrl, ciInfo.ciPipelineUrl) && Objects.equals(this.ciJobUrl, ciInfo.ciJobUrl) && Objects.equals(this.ciWorkspace, ciInfo.ciWorkspace) && Objects.equals(this.ciEnvVars, ciInfo.ciEnvVars);
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + (this.ciProviderName == null ? 0 : this.ciProviderName.hashCode());
            hash = 31 * hash + (this.ciPipelineId == null ? 0 : this.ciPipelineId.hashCode());
            hash = 31 * hash + (this.ciPipelineName == null ? 0 : this.ciPipelineName.hashCode());
            hash = 31 * hash + (this.ciStageName == null ? 0 : this.ciStageName.hashCode());
            hash = 31 * hash + (this.ciJobName == null ? 0 : this.ciJobName.hashCode());
            hash = 31 * hash + (this.ciPipelineNumber == null ? 0 : this.ciPipelineNumber.hashCode());
            hash = 31 * hash + (this.ciPipelineUrl == null ? 0 : this.ciPipelineUrl.hashCode());
            hash = 31 * hash + (this.ciJobUrl == null ? 0 : this.ciJobUrl.hashCode());
            hash = 31 * hash + (this.ciWorkspace == null ? 0 : this.ciWorkspace.hashCode());
            hash = 31 * hash + (this.ciEnvVars == null ? 0 : this.ciEnvVars.hashCode());
            return hash;
        }

        public String toString() {
            return "CIInfo{ciProviderName='" + this.ciProviderName + '\'' + ", ciPipelineId='" + this.ciPipelineId + '\'' + ", ciPipelineName='" + this.ciPipelineName + '\'' + ", ciStageName='" + this.ciStageName + '\'' + ", ciJobName='" + this.ciJobName + '\'' + ", ciPipelineNumber='" + this.ciPipelineNumber + '\'' + ", ciPipelineUrl='" + this.ciPipelineUrl + '\'' + ", ciJobUrl='" + this.ciJobUrl + '\'' + ", ciWorkspace='" + this.ciWorkspace + '\'' + ", ciEnvVars='" + this.ciEnvVars + '\'' + '}';
        }

        public static final class Builder {
            private String ciProviderName;
            private String ciPipelineId;
            private String ciPipelineName;
            private String ciStageName;
            private String ciJobName;
            private String ciPipelineNumber;
            private String ciPipelineUrl;
            private String ciJobUrl;
            private String ciWorkspace;
            private Map<String, String> ciEnvVars;

            public Builder ciProviderName(String ciProviderName) {
                this.ciProviderName = ciProviderName;
                return this;
            }

            public Builder ciPipelineId(String ciPipelineId) {
                this.ciPipelineId = ciPipelineId;
                return this;
            }

            public Builder ciPipelineName(String ciPipelineName) {
                this.ciPipelineName = ciPipelineName;
                return this;
            }

            public Builder ciStageName(String ciStageName) {
                this.ciStageName = ciStageName;
                return this;
            }

            public Builder ciJobName(String ciJobName) {
                this.ciJobName = ciJobName;
                return this;
            }

            public Builder ciPipelineNumber(String ciPipelineNumber) {
                this.ciPipelineNumber = ciPipelineNumber;
                return this;
            }

            public Builder ciPipelineUrl(String ciPipelineUrl) {
                this.ciPipelineUrl = ciPipelineUrl;
                return this;
            }

            public Builder ciJobUrl(String ciJobUrl) {
                this.ciJobUrl = ciJobUrl;
                return this;
            }

            public Builder ciWorkspace(String ciWorkspace) {
                this.ciWorkspace = ciWorkspace;
                return this;
            }

            public Builder ciEnvVars(String ... ciEnvVarKeysArray) {
                if (ciEnvVarKeysArray == null || ciEnvVarKeysArray.length == 0) {
                    return this;
                }
                this.ciEnvVars = new HashMap<String, String>();
                for (String ciEnvVarKey : ciEnvVarKeysArray) {
                    String envVarVal = System.getenv(ciEnvVarKey);
                    if (envVarVal == null || envVarVal.isEmpty()) continue;
                    this.ciEnvVars.put(ciEnvVarKey, envVarVal);
                }
                return this;
            }

            public CIInfo build() {
                return new CIInfo(this.ciProviderName, this.ciPipelineId, this.ciPipelineName, this.ciStageName, this.ciJobName, this.ciPipelineNumber, this.ciPipelineUrl, this.ciJobUrl, this.ciWorkspace, this.ciEnvVars);
            }
        }
    }

    public static class CITagsBuilder {
        private final Map<String, String> ciTags = new HashMap<String, String>();

        public CITagsBuilder withCiProviderName(String ciProviderName) {
            return this.putTagValue("ci.provider.name", ciProviderName, new String[0]);
        }

        public CITagsBuilder withCiPipelineId(String ciPipelineId) {
            return this.putTagValue("ci.pipeline.id", ciPipelineId, new String[0]);
        }

        public CITagsBuilder withCiPipelineName(String ciPipelineName) {
            return this.putTagValue("ci.pipeline.name", ciPipelineName, new String[0]);
        }

        public CITagsBuilder withCiPipelineNumber(String ciPipelineNumber) {
            return this.putTagValue("ci.pipeline.number", ciPipelineNumber, new String[0]);
        }

        public CITagsBuilder withCiPipelineUrl(String ciPipelineUrl) {
            return this.putTagValue("ci.pipeline.url", ciPipelineUrl, new String[0]);
        }

        public CITagsBuilder withCiStageName(String ciStageName) {
            return this.putTagValue("ci.stage.name", ciStageName, new String[0]);
        }

        public CITagsBuilder withCiJobName(String ciJobName) {
            return this.putTagValue("ci.job.name", ciJobName, new String[0]);
        }

        public CITagsBuilder withCiJorUrl(String ciJobUrl) {
            return this.putTagValue("ci.job.url", ciJobUrl, new String[0]);
        }

        public CITagsBuilder withCiWorkspacePath(String ciWorkspacePath) {
            return this.putTagValue("ci.workspace_path", ciWorkspacePath, new String[0]);
        }

        public CITagsBuilder withCiEnvVars(Map<String, String> ciEnvVars) {
            if (ciEnvVars == null || ciEnvVars.isEmpty()) {
                return this;
            }
            return this.putTagValue("_dd.ci.env_vars", Strings.toJson(ciEnvVars), new String[0]);
        }

        public CITagsBuilder withGitRepositoryUrl(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.repository_url", userSuppliedGitInfo.getRepositoryURL(), ciGitInfo.getRepositoryURL(), localGitInfo.getRepositoryURL());
        }

        public CITagsBuilder withGitCommit(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.commit.sha", userSuppliedGitInfo.getCommit().getSha(), ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha());
        }

        public CITagsBuilder withGitBranch(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.branch", userSuppliedGitInfo.getBranch(), ciGitInfo.getBranch(), localGitInfo.getBranch());
        }

        public CITagsBuilder withGitTag(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            return this.putTagValue("git.tag", userSuppliedGitInfo.getTag(), ciGitInfo.getTag(), localGitInfo.getTag());
        }

        public CITagsBuilder withGitCommitAuthorName(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitAuthorName = userSuppliedGitInfo.getCommit().getAuthor().getName();
            String ciGitAuthorName = ciGitInfo.getCommit().getAuthor().getName();
            String localGitAuthorName = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getAuthor().getName() : null;
            return this.putTagValue("git.commit.author.name", userSuppliedGitAuthorName, ciGitAuthorName, localGitAuthorName);
        }

        public CITagsBuilder withGitCommitAuthorEmail(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitAuthorEmail = userSuppliedGitInfo.getCommit().getAuthor().getEmail();
            String ciGitAuthorEmail = ciGitInfo.getCommit().getAuthor().getEmail();
            String localGitAuthorEmail = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getAuthor().getEmail() : null;
            return this.putTagValue("git.commit.author.email", userSuppliedGitAuthorEmail, ciGitAuthorEmail, localGitAuthorEmail);
        }

        public CITagsBuilder withGitCommitAuthorDate(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitAuthorDate = userSuppliedGitInfo.getCommit().getAuthor().getISO8601Date();
            String ciGitAuthorDate = ciGitInfo.getCommit().getAuthor().getISO8601Date();
            String localGitAuthorDate = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getAuthor().getISO8601Date() : null;
            return this.putTagValue("git.commit.author.date", userSuppliedGitAuthorDate, ciGitAuthorDate, localGitAuthorDate);
        }

        public CITagsBuilder withGitCommitCommitterName(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitterName = userSuppliedGitInfo.getCommit().getCommitter().getName();
            String ciGitCommitterName = ciGitInfo.getCommit().getCommitter().getName();
            String localGitCommitterName = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getCommitter().getName() : null;
            return this.putTagValue("git.commit.committer.name", userSuppliedGitCommitterName, ciGitCommitterName, localGitCommitterName);
        }

        public CITagsBuilder withGitCommitCommitterEmail(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitterEmail = userSuppliedGitInfo.getCommit().getCommitter().getEmail();
            String ciGitCommitterEmail = ciGitInfo.getCommit().getCommitter().getEmail();
            String localCommitterEmail = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getCommitter().getEmail() : null;
            return this.putTagValue("git.commit.committer.email", userSuppliedGitCommitterEmail, ciGitCommitterEmail, localCommitterEmail);
        }

        public CITagsBuilder withGitCommitCommitterDate(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitterDate = userSuppliedGitInfo.getCommit().getCommitter().getISO8601Date();
            String ciGitCommitterDate = ciGitInfo.getCommit().getCommitter().getISO8601Date();
            String localGitCommitterDate = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getCommitter().getISO8601Date() : null;
            return this.putTagValue("git.commit.committer.date", userSuppliedGitCommitterDate, ciGitCommitterDate, localGitCommitterDate);
        }

        public CITagsBuilder withGitCommitMessage(GitInfo userSuppliedGitInfo, GitInfo ciGitInfo, GitInfo localGitInfo) {
            String userSuppliedGitCommitMessage = userSuppliedGitInfo.getCommit().getFullMessage();
            String ciGitCommitMessage = ciGitInfo.getCommit().getFullMessage();
            String localGitCommitMessage = this.isCommitShaEquals(ciGitInfo, localGitInfo) ? localGitInfo.getCommit().getFullMessage() : null;
            return this.putTagValue("git.commit.message", userSuppliedGitCommitMessage, ciGitCommitMessage, localGitCommitMessage);
        }

        public Map<String, String> build() {
            return this.ciTags;
        }

        private CITagsBuilder putTagValue(String tagKey, String tagValue, String ... fallbackValues) {
            if (tagValue != null) {
                this.ciTags.put(tagKey, tagValue);
            } else {
                for (String fallbackValue : fallbackValues) {
                    if (fallbackValue == null) continue;
                    this.ciTags.put(tagKey, fallbackValue);
                    break;
                }
            }
            return this;
        }

        private boolean isCommitShaEquals(GitInfo ciGitInfo, GitInfo localGitInfo) {
            String ciGitCommit = ciGitInfo.getCommit().getSha();
            String localFSGitCommit = localGitInfo.getCommit().getSha();
            return ciGitCommit == null || ciGitCommit.equalsIgnoreCase(localFSGitCommit);
        }
    }
}

