/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.common.sampling.RateSampler;
import datadog.trace.core.CoreSpan;

public class DeterministicSampler<T extends CoreSpan<T>>
implements RateSampler<T> {
    private static final long KNUTH_FACTOR = 1111111111111111111L;
    private static final double MAX = Math.pow(2.0, 64.0) - 1.0;
    private final float rate;

    public DeterministicSampler(double rate) {
        this.rate = (float)rate;
    }

    @Override
    public boolean sample(T span) {
        return span.getTraceId().toLong() * 1111111111111111111L + Long.MIN_VALUE < DeterministicSampler.cutoff(this.rate);
    }

    @Override
    public double getSampleRate() {
        return this.rate;
    }

    public static long cutoff(double rate) {
        if (rate < 0.5) {
            return (long)(rate * MAX) + Long.MIN_VALUE;
        }
        if (rate < 1.0) {
            return (long)(rate * MAX + -9.223372036854776E18);
        }
        return Long.MAX_VALUE;
    }
}

