/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.common.writer.Payload;
import datadog.trace.common.writer.RemoteResponseListener;

public interface RemoteApi {
    public Response sendSerializedTraces(Payload var1);

    public void addResponseListener(RemoteResponseListener var1);

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;
        private final String response;

        public static Response success(int status) {
            return new Response(true, status, null, null);
        }

        public static Response success(int status, String response) {
            return new Response(true, status, null, response);
        }

        public static Response success(int status, Throwable exception) {
            return new Response(true, status, exception, null);
        }

        public static Response failed(int status) {
            return new Response(false, status, null, null);
        }

        public static Response failed(Throwable exception) {
            return new Response(false, null, exception, null);
        }

        private Response(boolean success, Integer status, Throwable exception, String response) {
            this.success = success;
            this.status = status;
            this.exception = exception;
            this.response = response;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final Throwable exception() {
            return this.exception;
        }

        public final String response() {
            return this.response;
        }
    }
}

