/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.core.propagation.ContextInterpreter;
import datadog.trace.core.propagation.HttpCodec;
import java.util.Map;

public class TagContextExtractor
implements HttpCodec.Extractor {
    protected final Map<String, String> taggedHeaders;
    private final ThreadLocal<ContextInterpreter> ctxInterpreter;

    public TagContextExtractor(final Map<String, String> taggedHeaders, final ContextInterpreter.Factory factory) {
        this.taggedHeaders = taggedHeaders;
        this.ctxInterpreter = new ThreadLocal<ContextInterpreter>(){

            @Override
            protected ContextInterpreter initialValue() {
                return factory.create(taggedHeaders);
            }
        };
    }

    @Override
    public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        ContextInterpreter interpreter = this.ctxInterpreter.get().reset();
        getter.forEachKey(carrier, interpreter);
        return interpreter.build();
    }
}

