/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.core.propagation.DatadogTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatadogTagsFactory
implements DatadogTags.Factory {
    private static final Logger log = LoggerFactory.getLogger(DatadogTagsFactory.class);
    private static final String ALLOWED_TAG_PREFIX = "_dd.p.";
    private static final String DECISION_MAKER_TAG = "_dd.p.dm";
    private static final String UPSTREAM_SERVICES_DEPRECATED_TAG = "_dd.p.upstream_services";
    private static final String PROPAGATION_ERROR_TAG_KEY = "_dd.propagation_error";
    private static final String PROPAGATION_ERROR_EXTRACT_MAX_SIZE = "extract_max_size";
    private static final String PROPAGATION_ERROR_INJECT_MAX_SIZE = "inject_max_size";
    private static final String PROPAGATION_ERROR_DISABLED = "disabled";
    private static final String PROPAGATION_ERROR_DECODING_ERROR = "decoding_error";
    private static final char TAGS_SEPARATOR = ',';
    private static final char TAG_KEY_SEPARATOR = '=';
    private static final int MIN_ALLOWED_CHAR = 32;
    private static final int MAX_ALLOWED_CHAR = 126;
    private final int datadogTagsLimit;

    DatadogTagsFactory(int datadogTagsLimit) {
        this.datadogTagsLimit = datadogTagsLimit;
    }

    @Override
    public DatadogTags empty() {
        return new ValidDatadogTags(Collections.emptyList());
    }

    @Override
    public DatadogTags fromHeaderValue(String value) {
        if (value == null) {
            return this.empty();
        }
        if (value.length() > this.datadogTagsLimit) {
            return new InvalidDatadogTags(PROPAGATION_ERROR_EXTRACT_MAX_SIZE);
        }
        ArrayList<String> tagPairs = new ArrayList<String>(10);
        int len = value.length();
        int tagPos = 0;
        while (tagPos < len) {
            int tagKeyEndsAt = value.indexOf(61, tagPos);
            if (tagKeyEndsAt < 0 || tagKeyEndsAt == len) {
                log.warn("Invalid datadog tags header value: '{}' tag without a value at {}", (Object)value, (Object)tagPos);
                return new InvalidDatadogTags(PROPAGATION_ERROR_DECODING_ERROR);
            }
            int tagValuePos = tagKeyEndsAt + 1;
            int tagValueEndsAt = value.indexOf(44, tagKeyEndsAt);
            if (tagValueEndsAt < 0) {
                tagValueEndsAt = len;
            }
            String tagKey = value.substring(tagPos, tagKeyEndsAt);
            String tagValue = value.substring(tagValuePos, tagValueEndsAt);
            if (!DatadogTagsFactory.validateTagKey(tagKey)) {
                log.warn("Invalid datadog tags header value: '{}' invalid tag key at {}", (Object)value, (Object)tagPos);
                return new InvalidDatadogTags(PROPAGATION_ERROR_DECODING_ERROR);
            }
            if (!DatadogTagsFactory.validateTagValue(tagKey, tagValue)) {
                log.warn("Invalid datadog tags header value: '{}' invalid tag value at {}", (Object)value, (Object)tagValuePos);
                return new InvalidDatadogTags(PROPAGATION_ERROR_DECODING_ERROR);
            }
            if (tagKey.startsWith(ALLOWED_TAG_PREFIX) && !tagKey.startsWith(UPSTREAM_SERVICES_DEPRECATED_TAG)) {
                tagPairs.add(tagKey);
                tagPairs.add(tagValue);
            }
            tagPos = tagValueEndsAt + 1;
        }
        return new ValidDatadogTags(tagPairs);
    }

    private static boolean validateTagKey(String tagKey) {
        for (int i = 0; i < tagKey.length(); ++i) {
            char c = tagKey.charAt(i);
            if (DatadogTagsFactory.isAllowedKeyChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateTagValue(String tagKey, String tagValue) {
        for (int i = 0; i < tagValue.length(); ++i) {
            char c = tagValue.charAt(i);
            if (DatadogTagsFactory.isAllowedValueChar(c)) continue;
            return false;
        }
        return !tagKey.equals(DECISION_MAKER_TAG) || DatadogTagsFactory.validateDecisionMakerTag(tagValue);
    }

    private static boolean isAllowedKeyChar(char c) {
        return c > ' ' && c <= '~' && c != ',';
    }

    private static boolean isAllowedValueChar(char c) {
        return c >= ' ' && c <= '~' && c != '=';
    }

    private static boolean validateDecisionMakerTag(String value) {
        int i;
        int sepPos = value.indexOf(45);
        if (sepPos < 0) {
            return false;
        }
        if (sepPos != 0 && sepPos != 10) {
            return false;
        }
        int samplingMechanismPos = sepPos + 1;
        int len = value.length();
        if (samplingMechanismPos == len) {
            return false;
        }
        for (i = 0; i < sepPos; ++i) {
            if (DatadogTagsFactory.isHexDigit(value.charAt(i))) continue;
            return false;
        }
        for (i = samplingMechanismPos; i < len; ++i) {
            if (DatadogTagsFactory.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || DatadogTagsFactory.isDigit(c);
    }

    private final class ValidDatadogTags
    extends DatadogTags {
        private final List<String> propagatedTagPairs;
        private final int propagatedTagsSize;
        private final boolean isDecisionMakerTagMissing;
        private volatile String decisionMakerTagValue;

        private ValidDatadogTags(List<String> tagPairs) {
            assert (tagPairs.size() % 2 == 0);
            this.propagatedTagPairs = tagPairs;
            this.propagatedTagsSize = this.calcTagsLength(tagPairs);
            this.isDecisionMakerTagMissing = !this.containsTag(tagPairs, DatadogTagsFactory.DECISION_MAKER_TAG);
        }

        private int calcTagsLength(List<String> tagPairs) {
            int size = 0;
            for (String tagPair : tagPairs) {
                size += tagPair.length();
                ++size;
            }
            return size - 1;
        }

        private boolean containsTag(List<String> tagPairs, String tagName) {
            for (int i = 0; i < tagPairs.size(); i += 2) {
                if (!tagPairs.get(i).equals(tagName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void updateTraceSamplingPriority(int samplingPriority, int samplingMechanism, String serviceName) {
            if (samplingPriority != -128 && this.isDecisionMakerTagMissing) {
                if (samplingPriority > 0) {
                    if (samplingMechanism >= 0) {
                        this.decisionMakerTagValue = "-" + samplingMechanism;
                    }
                } else {
                    this.decisionMakerTagValue = null;
                }
            }
        }

        @Override
        public String headerValue() {
            int newSize = this.countTagSize(this.propagatedTagsSize, DatadogTagsFactory.DECISION_MAKER_TAG, this.decisionMakerTagValue);
            if (newSize > DatadogTagsFactory.this.datadogTagsLimit) {
                return null;
            }
            Iterator<String> it = this.propagatedTagPairs.iterator();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                String tagKey = it.next();
                String tagValue = it.next();
                this.appendTag(sb, tagKey, tagValue);
            }
            if (this.isDecisionMakerTagMissing && this.decisionMakerTagValue != null) {
                this.appendTag(sb, DatadogTagsFactory.DECISION_MAKER_TAG, this.decisionMakerTagValue);
            }
            return sb.length() > 0 ? sb.toString() : null;
        }

        private int countTagSize(int size, String tagKey, String tagValue) {
            if (tagValue != null) {
                if (size > 0) {
                    ++size;
                }
                size += tagKey.length();
                ++size;
                size += tagValue.length();
            }
            return size;
        }

        private void appendTag(StringBuilder sb, String tagKey, String tagValue) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(tagKey);
            sb.append('=');
            sb.append(tagValue);
        }

        @Override
        public void fillTagMap(Map<String, String> tagMap) {
            int newSize = this.countTagSize(this.propagatedTagsSize, DatadogTagsFactory.DECISION_MAKER_TAG, this.decisionMakerTagValue);
            if (newSize > DatadogTagsFactory.this.datadogTagsLimit) {
                if (DatadogTagsFactory.this.datadogTagsLimit == 0) {
                    tagMap.put(DatadogTagsFactory.PROPAGATION_ERROR_TAG_KEY, DatadogTagsFactory.PROPAGATION_ERROR_DISABLED);
                } else {
                    tagMap.put(DatadogTagsFactory.PROPAGATION_ERROR_TAG_KEY, DatadogTagsFactory.PROPAGATION_ERROR_INJECT_MAX_SIZE);
                }
                return;
            }
            Iterator<String> it = this.propagatedTagPairs.iterator();
            while (it.hasNext()) {
                String tagKey = it.next();
                String tagValue = it.next();
                tagMap.put(tagKey, tagValue);
            }
            if (this.isDecisionMakerTagMissing && this.decisionMakerTagValue != null) {
                tagMap.put(DatadogTagsFactory.DECISION_MAKER_TAG, this.decisionMakerTagValue);
            }
        }
    }

    private static final class InvalidDatadogTags
    extends DatadogTags {
        private final String error;

        private InvalidDatadogTags(String error) {
            this.error = error;
        }

        @Override
        public void updateTraceSamplingPriority(int samplingPriority, int samplingMechanism, String serviceName) {
        }

        @Override
        public String headerValue() {
            return null;
        }

        @Override
        public void fillTagMap(Map<String, String> tagMap) {
            tagMap.put(DatadogTagsFactory.PROPAGATION_ERROR_TAG_KEY, this.error);
        }
    }
}

