/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.ddagent;

import datadog.common.container.ContainerInfo;
import datadog.common.socket.SocketUtils;
import datadog.communication.ddagent.DDAgentFeaturesDiscovery;
import datadog.communication.ddagent.TracerVersion;
import datadog.communication.http.OkHttpUtils;
import datadog.communication.monitor.Monitoring;
import datadog.trace.api.Config;
import datadog.trace.api.Platform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCommunicationObjects {
    private static final Logger log = LoggerFactory.getLogger(SharedCommunicationObjects.class);
    public OkHttpClient okHttpClient;
    public HttpUrl agentUrl;
    public Monitoring monitoring;
    private DDAgentFeaturesDiscovery featuresDiscovery;
    private Object configurationPoller;

    public void createRemaining(Config config) {
        if (this.monitoring == null) {
            this.monitoring = Monitoring.DISABLED;
        }
        if (this.agentUrl == null) {
            this.agentUrl = HttpUrl.parse((String)config.getAgentUrl());
        }
        if (this.okHttpClient == null) {
            String unixDomainSocket = SocketUtils.discoverApmSocket(config);
            String namedPipe = config.getAgentNamedPipe();
            this.okHttpClient = OkHttpUtils.buildHttpClient(this.agentUrl, unixDomainSocket, namedPipe, TimeUnit.SECONDS.toMillis(config.getAgentTimeout()));
        }
    }

    public Object configurationPoller(Config config) {
        if (this.configurationPoller != null) {
            return this.configurationPoller;
        }
        if (!SharedCommunicationObjects.isAtLeastJava8()) {
            return null;
        }
        try {
            this.configurationPoller = this.maybeCreatePoller(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Error creating remote configuration poller", (Throwable)e);
            return null;
        }
        return this.configurationPoller;
    }

    private Object maybeCreatePoller(Config config) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!config.isRemoteConfigEnabled()) {
            return null;
        }
        Class<?> confPollerCls = this.getClass().getClassLoader().loadClass("datadog.remoteconfig.ConfigurationPoller");
        Constructor<?> constructor = confPollerCls.getConstructor(Config.class, String.class, String.class, String.class, OkHttpClient.class);
        String containerId = ContainerInfo.get().getContainerId();
        String remoteConfigUrl = config.getFinalRemoteConfigUrl();
        if (remoteConfigUrl != null) {
            return constructor.newInstance(config, TracerVersion.TRACER_VERSION, containerId, remoteConfigUrl, this.okHttpClient);
        }
        this.createRemaining(config);
        DDAgentFeaturesDiscovery fd = this.featuresDiscovery(config);
        String configEndpoint = fd.getConfigEndpoint();
        if (configEndpoint != null) {
            remoteConfigUrl = this.featuresDiscovery.buildUrl(configEndpoint).toString();
            return constructor.newInstance(config, TracerVersion.TRACER_VERSION, containerId, remoteConfigUrl, this.okHttpClient);
        }
        return null;
    }

    private static boolean isAtLeastJava8() {
        return Platform.isJavaVersionAtLeast(8, 0);
    }

    public void setFeaturesDiscovery(DDAgentFeaturesDiscovery featuresDiscovery) {
        this.featuresDiscovery = featuresDiscovery;
    }

    public DDAgentFeaturesDiscovery featuresDiscovery(Config config) {
        if (this.featuresDiscovery == null) {
            this.createRemaining(config);
            this.featuresDiscovery = new DDAgentFeaturesDiscovery(this.okHttpClient, this.monitoring, this.agentUrl, config.isTraceAgentV05Enabled(), config.isTracerMetricsEnabled());
            if (!"true".equalsIgnoreCase(System.getProperty("dd.test.no.early.discovery"))) {
                this.featuresDiscovery.discover();
            }
        }
        return this.featuresDiscovery;
    }
}

