/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.trace.api.ConfigCollector;
import datadog.trace.bootstrap.config.provider.CapturedEnvironmentConfigSource;
import datadog.trace.bootstrap.config.provider.ConfigConverter;
import datadog.trace.bootstrap.config.provider.EnvironmentConfigSource;
import datadog.trace.bootstrap.config.provider.PropertiesConfigSource;
import datadog.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigProvider.class);
    protected final Source[] sources;

    private ConfigProvider(Source ... sources) {
        this.sources = sources;
    }

    public final String getConfigFileStatus() {
        for (Source source : this.sources) {
            String configFileStatus;
            if (!(source instanceof PropertiesConfigSource) || null == (configFileStatus = ((PropertiesConfigSource)source).getConfigFileStatus())) continue;
            return configFileStatus;
        }
        return "no config file present";
    }

    public final String getString(String key) {
        return this.getString(key, null, new String[0]);
    }

    public final <T extends Enum<T>> T getEnum(String key, Class<T> enumType, T defaultValue) {
        String value = this.getString(key);
        if (null != value) {
            try {
                return Enum.valueOf(enumType, value);
            }
            catch (Exception ignoreAndUseDefault) {
                log.debug("failed to parse {} for {}, defaulting to {}", new Object[]{value, key, defaultValue});
            }
        }
        return defaultValue;
    }

    public final String getString(String key, String defaultValue, String ... aliases) {
        for (Source source : this.sources) {
            String value = source.get(key, aliases);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public final String getStringExcludingSource(String key, String defaultValue, Class<? extends Source> excludedSource, String ... aliases) {
        for (Source source : this.sources) {
            String value;
            if (excludedSource.isAssignableFrom(source.getClass()) || (value = source.get(key, aliases)) == null) continue;
            return value;
        }
        return defaultValue;
    }

    public final boolean isSet(String key) {
        String value = this.getString(key);
        return value != null && !value.isEmpty();
    }

    public final Boolean getBoolean(String key) {
        return this.get(key, null, Boolean.class, new String[0]);
    }

    public final Boolean getBoolean(String key, String ... aliases) {
        return this.get(key, null, Boolean.class, aliases);
    }

    public final boolean getBoolean(String key, boolean defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Boolean.class, aliases);
    }

    public final Integer getInteger(String key) {
        return this.get(key, null, Integer.class, new String[0]);
    }

    public final Integer getInteger(String key, String ... aliases) {
        return this.get(key, null, Integer.class, aliases);
    }

    public final int getInteger(String key, int defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Integer.class, aliases);
    }

    public final Long getLong(String key) {
        return this.get(key, null, Long.class, new String[0]);
    }

    public final Long getLong(String key, String ... aliases) {
        return this.get(key, null, Long.class, aliases);
    }

    public final long getLong(String key, long defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Long.class, aliases);
    }

    public final Float getFloat(String key, String ... aliases) {
        return this.get(key, null, Float.class, aliases);
    }

    public final float getFloat(String key, float defaultValue) {
        return this.get(key, Float.valueOf(defaultValue), Float.class, new String[0]).floatValue();
    }

    public final Double getDouble(String key) {
        return this.get(key, null, Double.class, new String[0]);
    }

    public final double getDouble(String key, double defaultValue) {
        return this.get(key, defaultValue, Double.class, new String[0]);
    }

    private <T> T get(String key, T defaultValue, Class<T> type, String ... aliases) {
        for (Source source : this.sources) {
            T value;
            try {
                value = ConfigConverter.valueOf(source.get(key, aliases), type);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            if (value == null) continue;
            ConfigCollector.get().put(key, value);
            return value;
        }
        return defaultValue;
    }

    public final List<String> getList(String key) {
        return ConfigConverter.parseList(this.getString(key));
    }

    public final Set<String> getSet(String key, Set<String> defaultValue) {
        String list = this.getString(key);
        if (null == list) {
            return defaultValue;
        }
        return new HashSet<String>(ConfigConverter.parseList(this.getString(key)));
    }

    public final List<String> getSpacedList(String key) {
        return ConfigConverter.parseList(this.getString(key), " ");
    }

    public final Map<String, String> getMergedMap(String key) {
        HashMap<String, String> merged = new HashMap<String, String>();
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key);
            merged.putAll(ConfigConverter.parseMap(value, key));
        }
        return merged;
    }

    public final Map<String, String> getOrderedMap(String key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key);
            map.putAll(ConfigConverter.parseOrderedMap(value, key));
        }
        return map;
    }

    public final Map<String, String> getMergedMapWithOptionalMappings(String defaultPrefix, boolean lowercaseKeys, String ... keys) {
        HashMap<String, String> merged = new HashMap<String, String>();
        for (String key : keys) {
            for (int i = this.sources.length - 1; 0 <= i; --i) {
                String value = this.sources[i].get(key);
                merged.putAll(ConfigConverter.parseMapWithOptionalMappings(value, key, defaultPrefix, lowercaseKeys));
            }
        }
        return merged;
    }

    public BitSet getIntegerRange(String key, BitSet defaultValue) {
        String value = this.getString(key);
        try {
            return value == null ? defaultValue : ConfigConverter.parseIntegerRangeSet(value, key);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for " + key, (Throwable)e);
            return defaultValue;
        }
    }

    public static ConfigProvider getInstance() {
        return Singleton.INSTANCE;
    }

    public static ConfigProvider createDefault() {
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource()));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new CapturedEnvironmentConfigSource());
    }

    public static ConfigProvider withPropertiesOverride(Properties properties) {
        PropertiesConfigSource providedConfigSource = new PropertiesConfigSource(properties, false);
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), providedConfigSource));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), providedConfigSource, new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(providedConfigSource, new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new CapturedEnvironmentConfigSource());
    }

    @SuppressForbidden
    private static Properties loadConfigurationFile(ConfigProvider configProvider) {
        Properties properties = new Properties();
        String configurationFilePath = configProvider.getString("trace.config");
        if (null == configurationFilePath) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try (FileReader fileReader = new FileReader(configurationFile);){
            properties.load(fileReader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        properties.setProperty("_dd.config.file.status", configurationFilePath);
        return properties;
    }

    public static abstract class Source {
        public final String get(String key, String ... aliases) {
            String value = this.get(key);
            if (value != null) {
                return value;
            }
            for (String alias : aliases) {
                value = this.get(alias);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        protected abstract String get(String var1);
    }

    private static final class Singleton {
        private static final ConfigProvider INSTANCE = ConfigProvider.createDefault();

        private Singleton() {
        }
    }
}

