/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class RawParseUtils {
    public static final byte[] COMMITTER = "committer ".getBytes();
    public static final byte[] AUTHOR = "author ".getBytes();
    private static final byte[] digits10 = new byte[58];

    private RawParseUtils() {
    }

    public static int commitMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.tagMessage(b, ptr);
    }

    public static int tagMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        if (ptr < sz && b[ptr] == 10) {
            return ptr + 1;
        }
        return -1;
    }

    public static int committer(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        if (ptr < sz && b[ptr] == 97) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, COMMITTER);
    }

    public static final int author(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.match(b, ptr, AUTHOR);
    }

    public static int nextLF(byte[] b, int ptr) {
        return RawParseUtils.next(b, ptr, '\n');
    }

    public static int nextLF(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            byte c;
            if ((c = b[ptr++]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static int next(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr++] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static int match(byte[] b, int ptr, byte[] src) {
        if (ptr + src.length > b.length) {
            return -1;
        }
        int i = 0;
        while (i < src.length) {
            if (b[ptr] != src[i]) {
                return -1;
            }
            ++i;
            ++ptr;
        }
        return ptr;
    }

    public static String decode(byte[] buffer, int start, int end) {
        ByteBuffer b = ByteBuffer.wrap(buffer, start, end - start);
        b.mark();
        try {
            CharsetDecoder d = StandardCharsets.UTF_8.newDecoder();
            d.onMalformedInput(CodingErrorAction.REPORT);
            d.onUnmappableCharacter(CodingErrorAction.REPORT);
            return d.decode(b).toString();
        }
        catch (CharacterCodingException e) {
            b.reset();
            return RawParseUtils.extractBinaryString(buffer, start, end);
        }
    }

    public static String extractBinaryString(byte[] buffer, int start, int end) {
        StringBuilder r = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            r.append((char)(buffer[i] & 0xFF));
        }
        return r.toString();
    }

    public static int lastIndexOfTrim(byte[] raw, char ch, int pos) {
        while (pos >= 0 && raw[pos] == 32) {
            --pos;
        }
        while (pos >= 0 && raw[pos] != ch) {
            --pos;
        }
        return pos;
    }

    public static long parseLongBase10(byte[] b, int ptr) {
        long r = 0L;
        int sign = 0;
        try {
            byte v;
            int sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr >= sz) {
                return 0L;
            }
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                    break;
                }
            }
            while (ptr < sz && (v = digits10[b[ptr]]) >= 0) {
                r = r * 10L + (long)v;
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return sign < 0 ? -r : r;
    }

    public static int parseBase10(byte[] b, int ptr) {
        int r = 0;
        int sign = 0;
        try {
            byte v;
            int sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr >= sz) {
                return 0;
            }
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                    break;
                }
            }
            while (ptr < sz && (v = digits10[b[ptr]]) >= 0) {
                r = r * 10 + v;
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return sign < 0 ? -r : r;
    }

    public static int parseTimeZoneOffset(byte[] b, int ptr) {
        int v = RawParseUtils.parseBase10(b, ptr);
        int tzMins = v % 100;
        int tzHours = v / 100;
        return tzHours * 60 + tzMins;
    }

    public static int findByte(byte[] bytes, byte b) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != b) continue;
            return i;
        }
        return -1;
    }

    static {
        Arrays.fill(digits10, (byte)-1);
        for (int i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.digits10[i] = (byte)(i - 48);
        }
    }
}

