/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.communication.monitor.Monitoring;
import datadog.communication.monitor.Recording;
import datadog.communication.serialization.ByteBufferConsumer;
import datadog.communication.serialization.FlushingBuffer;
import datadog.communication.serialization.WritableFormatter;
import datadog.communication.serialization.msgpack.MsgPackWriter;
import datadog.trace.common.writer.Payload;
import datadog.trace.common.writer.RemoteApi;
import datadog.trace.common.writer.RemoteMapper;
import datadog.trace.common.writer.RemoteMapperDiscovery;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.monitor.HealthMetrics;
import java.nio.ByteBuffer;
import java.util.List;
import org.jctools.counters.CountersFactory;
import org.jctools.counters.FixedSizeStripedLongCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadDispatcher
implements ByteBufferConsumer {
    private static final Logger log = LoggerFactory.getLogger(PayloadDispatcher.class);
    private final RemoteApi api;
    private final RemoteMapperDiscovery mapperDiscovery;
    private final HealthMetrics healthMetrics;
    private final Monitoring monitoring;
    private Recording batchTimer;
    private RemoteMapper mapper;
    private WritableFormatter packer;
    private final FixedSizeStripedLongCounter droppedSpanCount = CountersFactory.createFixedSizeStripedCounter((int)8);
    private final FixedSizeStripedLongCounter droppedTraceCount = CountersFactory.createFixedSizeStripedCounter((int)8);

    public PayloadDispatcher(RemoteMapperDiscovery mapperDiscovery, RemoteApi api, HealthMetrics healthMetrics, Monitoring monitoring) {
        this.mapperDiscovery = mapperDiscovery;
        this.api = api;
        this.healthMetrics = healthMetrics;
        this.monitoring = monitoring;
    }

    void flush() {
        if (null != this.packer) {
            this.packer.flush();
        }
    }

    public void onDroppedTrace(int spanCount) {
        this.droppedSpanCount.inc((long)spanCount);
        this.droppedTraceCount.inc();
    }

    void addTrace(List<? extends CoreSpan<?>> trace) {
        this.selectMapper();
        if (null == this.mapper || !this.packer.format(trace, this.mapper)) {
            this.healthMetrics.onFailedPublish(trace.get(0).samplingPriority());
        }
    }

    private void selectMapper() {
        if (null == this.mapper) {
            if (this.mapperDiscovery.getMapper() == null) {
                this.mapperDiscovery.discover();
            }
            this.mapper = this.mapperDiscovery.getMapper();
            if (null != this.mapper && null == this.packer) {
                this.batchTimer = this.monitoring.newTimer("tracer.trace.buffer.fill.time", "endpoint:" + this.mapper.endpoint());
                this.packer = new MsgPackWriter(new FlushingBuffer(this.mapper.messageBufferSize(), this));
                this.batchTimer.start();
            }
        }
    }

    Payload newPayload(int messageCount, ByteBuffer buffer) {
        return this.mapper.newPayload().withBody(messageCount, buffer).withDroppedSpans(this.droppedSpanCount.getAndReset()).withDroppedTraces(this.droppedTraceCount.getAndReset());
    }

    @Override
    public void accept(int messageCount, ByteBuffer buffer) {
        if (messageCount > 0) {
            this.batchTimer.reset();
            Payload payload = this.newPayload(messageCount, buffer);
            int sizeInBytes = payload.sizeInBytes();
            this.healthMetrics.onSerialize(sizeInBytes);
            RemoteApi.Response response = this.api.sendSerializedTraces(payload);
            this.mapper.reset();
            if (response.success()) {
                if (log.isDebugEnabled()) {
                    log.debug("Successfully sent {} traces to the API", (Object)messageCount);
                }
                this.healthMetrics.onSend(messageCount, sizeInBytes, response);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to send {} traces of size {} bytes to the API", (Object)messageCount, (Object)sizeInBytes);
                }
                this.healthMetrics.onFailedSend(messageCount, sizeInBytes, response);
            }
        }
    }
}

