/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

public final class TagsHelper {
    private static final int MAX_LENGTH = 200;

    public static String sanitize(String tag) {
        if (tag == null) {
            return null;
        }
        String lower = tag.toLowerCase().trim();
        int length = Math.min(lower.length(), 200);
        StringBuilder sanitized = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = lower.charAt(i);
            if (TagsHelper.isValid(c)) {
                sanitized.append(c);
                continue;
            }
            sanitized.append('_');
        }
        return sanitized.toString();
    }

    static boolean isValid(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '/' || c == ':';
    }
}

