/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.tag.Tags;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OperationDecorator
extends AbstractDecorator {
    static final Map<String, String> MAPPINGS;

    public OperationDecorator() {
        this.setMatchingTag(Tags.COMPONENT.getKey());
    }

    @Override
    public boolean shouldSetTag(DDSpanContext context, String tag, Object value) {
        if (MAPPINGS.containsKey(String.valueOf(value))) {
            context.setOperationName(MAPPINGS.get(String.valueOf(value)));
        }
        return true;
    }

    static {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("apache-httpclient", "apache.http");
        mappings.put("java-aws-sdk", "aws.http");
        mappings.put("java-jms", "jms");
        mappings.put("okhttp", "okhttp.http");
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

