/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.propagation;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.propagation.Codec;
import datadog.opentracing.propagation.ExtractedContext;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPCodec
implements Codec<TextMap> {
    private static final Logger log = LoggerFactory.getLogger(HTTPCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    private static final String TRACE_ID_KEY = "x-datadog-trace-id";
    private static final String SPAN_ID_KEY = "x-datadog-parent-id";
    private static final String SAMPLING_PRIORITY_KEY = "x-datadog-sampling-priority";
    private final Map<String, String> taggedHeaders = new HashMap<String, String>();

    public HTTPCodec(Map<String, String> taggedHeaders) {
        for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
            this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(), mapping.getValue());
        }
    }

    @Override
    public void inject(DDSpanContext context, TextMap carrier) {
        carrier.put(TRACE_ID_KEY, String.valueOf(context.getTraceId()));
        carrier.put(SPAN_ID_KEY, String.valueOf(context.getSpanId()));
        if (context.lockSamplingPriority()) {
            carrier.put(SAMPLING_PRIORITY_KEY, String.valueOf(context.getSamplingPriority()));
        }
        for (Map.Entry<String, String> entry : context.baggageItems()) {
            carrier.put(OT_BAGGAGE_PREFIX + entry.getKey(), this.encode(entry.getValue()));
        }
        log.debug("{} - Parent context injected", (Object)context.getTraceId());
    }

    @Override
    public ExtractedContext extract(TextMap carrier) {
        Map<String, String> baggage = Collections.emptyMap();
        Map<String, String> tags = Collections.emptyMap();
        Long traceId = 0L;
        Long spanId = 0L;
        int samplingPriority = Integer.MIN_VALUE;
        for (Map.Entry entry : carrier) {
            String key = ((String)entry.getKey()).toLowerCase();
            if (key.equalsIgnoreCase(TRACE_ID_KEY)) {
                traceId = Long.parseLong((String)entry.getValue());
            } else if (key.equalsIgnoreCase(SPAN_ID_KEY)) {
                spanId = Long.parseLong((String)entry.getValue());
            } else if (key.startsWith(OT_BAGGAGE_PREFIX)) {
                if (baggage.isEmpty()) {
                    baggage = new HashMap<String, String>();
                }
                baggage.put(key.replace(OT_BAGGAGE_PREFIX, ""), this.decode((String)entry.getValue()));
            } else if (key.equalsIgnoreCase(SAMPLING_PRIORITY_KEY)) {
                samplingPriority = Integer.parseInt((String)entry.getValue());
            }
            if (!this.taggedHeaders.containsKey(key)) continue;
            if (tags.isEmpty()) {
                tags = new HashMap<String, String>();
            }
            tags.put(this.taggedHeaders.get(key), this.decode((String)entry.getValue()));
        }
        ExtractedContext context = null;
        if (traceId != 0L) {
            context = new ExtractedContext(traceId, spanId, samplingPriority, baggage, tags);
            context.lockSamplingPriority();
            log.debug("{} - Parent context extracted", (Object)context.getTraceId());
        }
        return context;
    }

    private String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    private String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }
}

