/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.resolver;

import datadog.opentracing.DDTracer;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDTracerResolver
extends TracerResolver {
    private static final Logger log = LoggerFactory.getLogger(DDTracerResolver.class);

    public static Tracer registerTracer() {
        Tracer tracer = TracerResolver.resolveTracer();
        if (tracer == null) {
            log.warn("Cannot resolved the tracer, use NoopTracer");
            return NoopTracerFactory.create();
        }
        log.info("Register the tracer via GlobalTracer");
        GlobalTracer.register((Tracer)tracer);
        return tracer;
    }

    protected Tracer resolve() {
        log.info("Creating the Datadog Tracer from the resolver");
        return new DDTracer();
    }
}

