/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.util.Strings;
import java.util.ArrayList;
import java.util.List;

public final class Platform {
    private static final Version JAVA_VERSION = Platform.parseJavaVersion(System.getProperty("java.version"));
    private static final JvmRuntime RUNTIME = new JvmRuntime();

    public static boolean hasJfr() {
        return ClassLoader.getSystemClassLoader().getResource("jdk/jfr/Event.class") != null;
    }

    private static List<Integer> splitDigits(String str) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int len = str.length();
        int value = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                value = value * 10 + (ch - 48);
                continue;
            }
            if (ch == '.' || ch == '_' || ch == '+') {
                results.add(value);
                value = 0;
                continue;
            }
            throw new NumberFormatException();
        }
        results.add(value);
        return results;
    }

    private static Version parseJavaVersion(String javaVersion) {
        javaVersion = Strings.replace(javaVersion, "-ea", "");
        int major = 0;
        int minor = 0;
        int update = 0;
        try {
            List<Integer> nums = Platform.splitDigits(javaVersion);
            major = nums.get(0);
            if (major == 1) {
                major = nums.get(1);
                minor = nums.get(2);
                update = nums.get(3);
            } else {
                minor = nums.get(1);
                update = nums.get(2);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return new Version(major, minor, update);
    }

    public static boolean isJavaVersion(int major) {
        return JAVA_VERSION.is(major);
    }

    public static boolean isJavaVersion(int major, int minor) {
        return JAVA_VERSION.is(major, minor);
    }

    public static boolean isJavaVersion(int major, int minor, int update) {
        return JAVA_VERSION.is(major, minor, update);
    }

    public static boolean isJavaVersionAtLeast(int major) {
        return Platform.isJavaVersionAtLeast(major, 0, 0);
    }

    public static boolean isJavaVersionAtLeast(int major, int minor) {
        return Platform.isJavaVersionAtLeast(major, minor, 0);
    }

    public static boolean isJavaVersionAtLeast(int major, int minor, int update) {
        return JAVA_VERSION.isAtLeast(major, minor, update);
    }

    public static boolean isJavaVersionBetween(int fromMajor, int toMajor) {
        return Platform.isJavaVersionBetween(fromMajor, 0, toMajor, 0);
    }

    public static boolean isJavaVersionBetween(int fromMajor, int fromMinor, int toMajor, int toMinor) {
        return Platform.isJavaVersionBetween(fromMajor, fromMinor, 0, toMajor, toMinor, 0);
    }

    public static boolean isJavaVersionBetween(int fromMajor, int fromMinor, int fromUpdate, int toMajor, int toMinor, int toUpdate) {
        return JAVA_VERSION.isBetween(fromMajor, fromMinor, fromUpdate, toMajor, toMinor, toUpdate);
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac");
    }

    public static boolean isOracleJDK8() {
        return Platform.isJavaVersion(8) && Platform.RUNTIME.vendor.contains("Oracle") && !Platform.RUNTIME.name.contains("OpenJDK");
    }

    public static String getLangVersion() {
        return String.valueOf(Platform.JAVA_VERSION.major);
    }

    public static String getRuntimeVendor() {
        return Platform.RUNTIME.vendor;
    }

    public static String getRuntimeVersion() {
        return Platform.RUNTIME.version;
    }

    public static String getRuntimePatches() {
        return Platform.RUNTIME.patches;
    }

    static final class JvmRuntime {
        public final String name;
        public final String vendor;
        public final String version;
        public final String patches;

        public JvmRuntime() {
            String rtVer = System.getProperty("java.runtime.version");
            String javaVer = System.getProperty("java.version");
            this.name = System.getProperty("java.runtime.name");
            this.vendor = System.getProperty("java.vm.vendor");
            this.version = javaVer;
            this.patches = rtVer.substring(javaVer.length() + 1);
        }
    }

    static final class Version {
        public final int major;
        public final int minor;
        public final int update;

        public Version(int major, int minor, int update) {
            this.major = major;
            this.minor = minor;
            this.update = update;
        }

        public boolean is(int major) {
            return this.major == major;
        }

        public boolean is(int major, int minor) {
            return this.major == major && this.minor == minor;
        }

        public boolean is(int major, int minor, int update) {
            return this.major == major && this.minor == minor && this.update == update;
        }

        public boolean isAtLeast(int major, int minor, int update) {
            return Version.isAtLeast(this.major, this.minor, this.update, major, minor, update);
        }

        public boolean isBetween(int fromMajor, int fromMinor, int fromUpdate, int toMajor, int toMinor, int toUpdate) {
            return Version.isAtLeast(toMajor, toMinor, toUpdate, fromMajor, fromMinor, fromUpdate) && this.isAtLeast(fromMajor, fromMinor, fromUpdate) && !this.isAtLeast(toMajor, toMinor, toUpdate);
        }

        private static boolean isAtLeast(int major, int minor, int update, int atLeastMajor, int atLeastMinor, int atLeastUpdate) {
            return major > atLeastMajor || major == atLeastMajor && minor > atLeastMinor || major == atLeastMajor && minor == atLeastMinor && update >= atLeastUpdate;
        }
    }
}

