/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.cache;

import datadog.trace.api.cache.DDCache;
import datadog.trace.api.function.Function;
import java.util.concurrent.ConcurrentHashMap;

final class CHMCache<K, V>
implements DDCache<K, V> {
    private final ConcurrentHashMap<K, V> chm;

    public CHMCache(int initialCapacity) {
        this.chm = new ConcurrentHashMap(initialCapacity);
    }

    @Override
    public V computeIfAbsent(K key, Function<K, ? extends V> func) {
        V winner;
        if (null == key) {
            return null;
        }
        V value = this.chm.get(key);
        if (null == value && null != (winner = this.chm.putIfAbsent(key, value = func.apply(key)))) {
            value = winner;
        }
        return value;
    }

    @Override
    public void clear() {
        this.chm.clear();
    }
}

