/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.civisibility.writer.ddintake;

import datadog.communication.http.OkHttpUtils;
import datadog.communication.serialization.Writable;
import datadog.trace.api.WellKnownTags;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.Payload;
import datadog.trace.common.writer.RemoteMapper;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;

public class CiTestCycleMapperV1
implements RemoteMapper {
    public static final byte[] VERSION = "version".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METADATA = "metadata".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METADATA_ASTERISK = "*".getBytes(StandardCharsets.UTF_8);
    public static final byte[] EVENTS = "events".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ENV = "env".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    public static final byte[] CONTENT = "content".getBytes(StandardCharsets.UTF_8);
    public static final UTF8BytesString TEST_TYPE = UTF8BytesString.create("test");
    public static final UTF8BytesString SPAN_TYPE = UTF8BytesString.create("span");
    private final WellKnownTags wellKnownTags;
    private final int size;
    private final MetaWriter metaWriter = new MetaWriter();

    public CiTestCycleMapperV1(WellKnownTags wellKnownTags, int size) {
        this.wellKnownTags = wellKnownTags;
        this.size = size;
    }

    public CiTestCycleMapperV1(WellKnownTags wellKnownTags) {
        this(wellKnownTags, 0x500000);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startMap(3);
        writable.writeUTF8(VERSION);
        writable.writeInt(1);
        writable.writeUTF8(METADATA);
        writable.startMap(1);
        writable.writeUTF8(METADATA_ASTERISK);
        writable.startMap(3);
        writable.writeUTF8(ENV);
        writable.writeUTF8(this.wellKnownTags.getEnv());
        writable.writeUTF8(RUNTIME_ID);
        writable.writeUTF8(this.wellKnownTags.getRuntimeId());
        writable.writeUTF8(LANGUAGE);
        writable.writeUTF8(this.wellKnownTags.getLanguage());
        writable.writeUTF8(EVENTS);
        writable.startArray(trace.size());
        for (int i = 0; i < trace.size(); ++i) {
            CoreSpan<?> span = trace.get(i);
            writable.startMap(3);
            writable.writeUTF8(TYPE);
            if (TEST_TYPE.equals(span.getType())) {
                writable.writeUTF8(TEST_TYPE);
            } else {
                writable.writeUTF8(SPAN_TYPE);
            }
            writable.writeUTF8(VERSION);
            writable.writeInt(1);
            writable.writeUTF8(CONTENT);
            writable.startMap(11);
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeLong(span.getTraceId().toLong());
            writable.writeUTF8(SPAN_ID);
            writable.writeLong(span.getSpanId().toLong());
            writable.writeUTF8(PARENT_ID);
            writable.writeLong(span.getParentId().toLong());
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV1();
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endpoint() {
        return "citestcycle/v1";
    }

    private static class PayloadV1
    extends Payload {
        private PayloadV1() {
        }

        @Override
        public int sizeInBytes() {
            return this.body.remaining();
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            if (this.traceCount() == 0) {
                ByteBuffer header = this.msgpackMapHeader(0);
                while (header.hasRemaining()) {
                    channel.write(header);
                }
            } else {
                while (this.body.hasRemaining()) {
                    channel.write(this.body);
                }
            }
        }

        @Override
        public RequestBody toRequest() {
            if (this.traceCount() == 0) {
                return OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.msgpackMapHeader(0)));
            }
            return OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.body));
        }
    }

    private static final class MetaWriter
    extends MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1);
            int metricsSize = 0;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.writeUTF8(RemoteMapper.METRICS);
            this.writable.startMap(metricsSize);
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(RemoteMapper.META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(RemoteMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (entry.getValue() instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObjectString(entry.getValue(), null);
            }
        }
    }
}

