/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddintake;

import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.core.DDSpan;
import datadog.trace.util.TraceUtils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDIntakeTraceInterceptor
implements TraceInterceptor {
    public static final DDIntakeTraceInterceptor INSTANCE = new DDIntakeTraceInterceptor();
    private static final Logger log = LoggerFactory.getLogger(DDIntakeTraceInterceptor.class);

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> trace) {
        if (trace.isEmpty()) {
            return trace;
        }
        for (MutableSpan mutableSpan : trace) {
            if (!(mutableSpan instanceof DDSpan)) continue;
            this.process((DDSpan)mutableSpan);
        }
        return trace;
    }

    private void process(DDSpan span) {
        short httpStatusCode;
        span.setServiceName(TraceUtils.normalizeServiceName(span.getServiceName()));
        span.setOperationName(TraceUtils.normalizeOperationName(span.getOperationName()));
        span.setSpanType(TraceUtils.normalizeSpanType(span.getSpanType()));
        if (span.getResourceName() == null || span.getResourceName().length() == 0) {
            log.debug("Fixing malformed trace. Resource is empty (reason:resource_empty), setting span.resource={}: {}", (Object)span.getOperationName(), (Object)span);
            span.setResourceName(span.getOperationName());
        }
        if (span.getTag("env") != null) {
            span.setTag("env", TraceUtils.normalizeEnv((String)span.getTag("env")));
        }
        if (!TraceUtils.isValidStatusCode(httpStatusCode = span.getHttpStatusCode())) {
            log.debug("Fixing malformed trace. HTTP status code is invalid (reason:invalid_http_status_code), dropping invalid http.status_code={}: {}", (Object)httpStatusCode, (Object)span);
            span.setHttpStatusCode(0);
        }
    }

    public int priority() {
        return 0;
    }
}

